/*
 * Voyager JBoss OpenTool for JBuilder
 *
 * Copyright (c) 2002 Marcus Redeker, Gedoplan GmbH - Bielefeld, Germany
 *    marcus.redeker@gedoplan.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Cyrille Morvan's excellent 'Kelly JOnAS OpenTool' sources provided
 * much of the inspiration and some of the code for this OpenTool.
 *
*/
package de.gedoplan.opentools.jboss;

import com.borland.primetime.properties.*;


/**
 * The JBossPropertyGroup is used to save all available settings for the OpenTool in the JBuilder
 * property file.
 *
 * @author <a href="mailto:marcus.redeker@gedoplan.de">Marcus Redeker (Gedoplan GmbH, Germany)</a>
 * @author <a href="mailto:fred.sauer@allen-sauer.com">Frederik Sauer</a>
 * @version 1.2
 */
public class JBossPropertyGroup implements PropertyGroup
{
  public static final GlobalProperty INSTALL_PATH_24 = new GlobalProperty("jboss", "install.path.24");
  public static final GlobalProperty INSTALL_PATH_30 = new GlobalProperty("jboss", "install.path.30");
  public static final GlobalProperty CONFIGURATION_NAME_24 = new GlobalProperty("jboss", "configuration.name.24");
  public static final GlobalProperty CONFIGURATION_NAME_30 = new GlobalProperty("jboss", "configuration.name.30");
  public static final GlobalProperty DEPLOY_DIRECTORY_NAME_24 = new GlobalProperty("jboss", "deploy.directory.name.24", "deploy");
  public static final GlobalProperty DEPLOY_DIRECTORY_NAME_30 = new GlobalProperty("jboss", "deploy.directory.name.30", "deploy");
  public static final MultipleNodeProperty ADD_PROJECT_CLASSPATH_ON_DEPLOY_NODE = new MultipleNodeProperty("jboss", "add.project.classpath.on.deploy", "0");
  public static final GlobalBooleanProperty ADD_PROJECT_CLASSPATH_ON_DEPLOY_GLOBAL = new GlobalBooleanProperty("jboss", "add.project.classpath.on.deploy", false);

  public JBossPropertyGroup()
  {
  }

  public void initializeProperties()
  {
  }

  public static void initOpenTool(byte byte0, byte byte1)
  {
      PropertyManager.registerPropertyGroup(new JBossPropertyGroup());
  }

  public PropertyPageFactory getPageFactory(Object parm1)
  {
    return null;
  }
}