/*
 * Voyager JBoss OpenTool for JBuilder
 *
 * Copyright (c) 2002 Marcus Redeker, Gedoplan GmbH - Bielefeld, Germany
 *    marcus.redeker@gedoplan.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Cyrille Morvan's excellent 'Kelly JOnAS OpenTool' sources provided
 * much of the inspiration and some of the code for this OpenTool.
 *
*/
package de.gedoplan.opentools.jboss;

import java.util.*;


/**
 * The JBossResource class is the resource bundle for this project.
 *
 * @author <a href="mailto:marcus.redeker@gedoplan.de">Marcus Redeker (Gedoplan GmbH, Germany)</a>
 * @version 1.2
 */
public class JBossResource extends ListResourceBundle
{
  /**
   * I call this Voyager just because I love Star Trek
   */
  public static final String COMMERCIAL_NAME = "Voyager";

  public static final String VOYAGER_VERSION = "2.0";

  private static ResourceBundle res ;

  private static final Object[][] contents =
  {
    // contributors separate by comma
    { "AUTHORS" , "Marcus Redeker <mr@gedoplan.de>, Frederik Sauer <fred@allen-sauer.com>" },
    { "URL" , "http://sourceforge.net/projects/jboss-opentool/" },

    // server name
    { "SERVER_NAME" , "JBoss" },
    // server version
    { "SERVER_VERSION24", "2.4.x" },
    { "SERVER_VERSION30", "3.x" },

    // description in setup box 2.4.x
    { "SERVER_DESCRIPTION24" , "Enter the installation directory for JBoss. You should already have installed JBoss 2.4.x (or greater) in this directory." +
                             "The configuration is used to tell jBuilder which JBoss configuration to start. After selecting a valid installation directory" +
                             " you can select a configuration from all available configurations in the drop down box."} ,

    // description in setup box 3.x
    { "SERVER_DESCRIPTION30" , "Enter the installation directory for JBoss. You should already have installed JBoss 3.x (or greater) in this directory." +
                             "The configuration is used to tell jBuilder which JBoss configuration to start. After selecting a valid installation directory" +
                             " you can select a configuration from all available configurations in the drop down box."} ,

    // text in setup box
    { "INSTALLATION_DIRECTORY" , "JBoss installation directory :" },
    { "CONFIGURATION_DIRECTORY" , "JBoss configuration to use :" },
    { "INSTALL_FILE_CHOOSER_TITLE" , "Select JBoss Installation Directory" },

    // setup errors
    { "INSTALL_DIRECTORY_EMPTY" , "Installation directory cannot be empty." },
    { "CONF_NAME_EMPTY" , "Configuration name cannot be empty." },
    { "CONF_NAME_WRONG1" , "The configuration '" },
    { "CONF_NAME_WRONG2" , "' does not exist.\n Check " },
    { "CONF_NAME_WRONG3" , " for valid configurations." },
    { "MISSING_FILE" , "It isn't a JBoss installation directory." },

    // deployment descriptor errors
    { "MISSING_EJB_REF_JNDI_NAME" , "No JNDI-Name is specified for EJB-Reference: " },
    { "MISSING_EJB_LOCAL_REF_JNDI_NAME", "No JNDI-Name is specified for EJB-Local-References: "},
    { "MISSING_RES_REF_JNDI_NAME" , "No JNDI-Name is specified for Resource-Reference: " },
    { "MISSING_RES_ENV_REF_JNDI_NAME" , "No JNDI-Name is specified for Resource-Environment-Reference: " },

    // deployer messages
    { "DEPLOYER_MESSAGE" , "No extra deployment tool is available. Just right click the node to \n" +
                           "deploy and select 'Deploy' from the available deploy options." },
    { "DEPLOYMENT" , " Deployment" },
    { "DEPLOYMENT_DESCRIPTOR" , " Deployment Descriptor" },
    { "REDEPLOYMENT" , " Redeployment" },
    { "UNDEPLOYMENT" , " Undeployment" },
    { "LIST_DEPLOYMENT" , " List Deployments" },
    { "LIST_DEPLOYMENT_HEADER" , "The following applications are deployed in: " },
    { "DEPLOY_CHECK_MSG" , "Check the JBoss console for results." },



    // for About box dialog
    { "ABOUT_BOX_BUTTON" , "About..." },
    { "ABOUT_BOX" , "About JBoss OpenTool - Version: " }
  };

  static
  {
    res = ResourceBundle.getBundle(JBossResource.class.getName());
  }

  public JBossResource()
  {
  }

  public static String get(String aString)
  {
    return res.getString(aString);
  }

  public static String getDefaultName24()
  {
    StringBuffer aStringBuffer = new StringBuffer();
    aStringBuffer.append(res.getString("SERVER_NAME"));
    aStringBuffer.append(' ');
    aStringBuffer.append(res.getString("SERVER_VERSION24"));
    return aStringBuffer.toString();
  }

  public static String getDefaultName30()
  {
    StringBuffer aStringBuffer = new StringBuffer();
    aStringBuffer.append(res.getString("SERVER_NAME"));
    aStringBuffer.append(' ');
    aStringBuffer.append(res.getString("SERVER_VERSION30"));
    return aStringBuffer.toString();
  }

  public Object[][] getContents()
  {
    return contents;
  }
}
