/*
 * Voyager JBoss OpenTool for JBuilder
 *
 * Copyright (c) 2002 Marcus Redeker, Gedoplan GmbH - Bielefeld, Germany
 *    marcus.redeker@gedoplan.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Cyrille Morvan's excellent 'Kelly JOnAS OpenTool' sources provided
 * much of the inspiration and some of the code for this OpenTool.
 *
*/
package de.gedoplan.opentools.jboss;

import com.borland.primetime.properties.PropertyPage;
import com.borland.primetime.ide.Browser;

import com.borland.jbuilder.ide.Setup;
import com.borland.jbuilder.ide.SetupManager;
import com.borland.jbuilder.enterprise.ejb.AppServerSetup;
import com.borland.jbuilder.info.JBuilderInfo;

import java.io.File;


/**
 * JBossSetup returns the property page which is displayed under menu Tools/Enterprise Setup
 *
 * @author <a href="mailto:marcus.redeker@gedoplan.de">Marcus Redeker (Gedoplan GmbH, Germany)</a>
 * @version 1.2
 */
public class JBossSetup30 extends JBossSetup24
{

  public JBossSetup30()
  {
  }

  /**
  * JB init
  */
  public static void initOpenTool(byte byte0, byte byte1)
  {
    SetupManager.registerSetup(new JBossSetup30(), AppServerSetup.APPSERVER_SETUP_NAME);
  }


  /**
  * get the property page.
  */
  protected PropertyPage getSetupPropertyPage(Browser aBrowser)
  {
    return new JBossSetupPropertyPage30(aBrowser);
  }

  /**
  * display name
  */
  public String getName()
  {
    return JBossResource.getDefaultName30();
  }


  public String validateInstallDirectory(String s)
  {
    return JBossSetupPropertyPage30.validateInstallDirectory(s);
  }

  public void saveSettings(String s)
  {
    JBossSetupSettings30 jbossSetupSettings = new JBossSetupSettings30();
    jbossSetupSettings.setInstallPath(s);
    jbossSetupSettings.setConfigName(JBossPropertyGroup.CONFIGURATION_NAME_30.getValue());
    JBossSetupPropertyPage30.saveJBossSettings(jbossSetupSettings);
  }

}
// eof