/*
 * Voyager JBoss OpenTool for JBuilder
 *
 * Copyright (c) 2002 Marcus Redeker, Gedoplan GmbH - Bielefeld, Germany
 *    marcus.redeker@gedoplan.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Cyrille Morvan's excellent 'Kelly JOnAS OpenTool' sources provided
 * much of the inspiration and some of the code for this OpenTool.
 *
*/
package de.gedoplan.opentools.jboss;

import com.borland.jbuilder.JBuilderHelp;
import com.borland.jbuilder.ide.SetupPropertyPage;
import com.borland.jbuilder.ide.SetupManager;
import com.borland.jbuilder.enterprise.ejb.AppServer;
import com.borland.jbuilder.enterprise.ejb.AppServerManager;
import com.borland.jbuilder.paths.PathSet;
import com.borland.jbuilder.enterprise.EnterpriseUtils;
import com.borland.jbuilder.enterprise.ejb.AppServerSetupPropertyPage;

import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.ui.UrlChooser;
import com.borland.primetime.ide.BrowserIcons;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.properties.*;
import com.borland.primetime.help.HelpTopic;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.*;


/**
 * Creates the property page which is displayed under menu Tools/Enterprise Setup
 *
 * @author <a href="mailto:marcus.redeker@gedoplan.de">Marcus Redeker (Gedoplan GmbH, Germany)</a>
 * @version 1.2
 */
public class JBossSetupPropertyPage24 extends AppServerSetupPropertyPage implements ActionListener
{

  private JTextField installTextFieldDirectoryPath = new JTextField();
//  private JTextField confTextFieldDirectory = new JTextField();
  protected JComboBox confTextFieldDirectory = new JComboBox();
  private ComboBoxModel confFieldModel = new DefaultComboBoxModel();

  private String install_directoryPath = null;
  private String conf_directory = null;

  private JButton jButtonInstallUrl = new JButton();
//  private JButton jButtonConfDir = new JButton();

  private JButton jButtonAbout = new JButton();

  private JBossSetupSettings24 initialSettings;


  /**
   * Constructor
   */
  public JBossSetupPropertyPage24(Browser browser)
  {
    super(browser);
    initialSettings = new JBossSetupSettings24();
  }

  /**
   * Get description to display on top
   */
  public String getDescription()
  {
    return JBossResource.get("SERVER_DESCRIPTION24");
  }

   /**
    * create the panel
    */
   public JPanel createSetupPanel()
   {
      JPanel aJPanel = new JPanel();
      aJPanel.setLayout(new GridBagLayout());

      // the install dir text field
      installTextFieldDirectoryPath.setEditable(false);
      installTextFieldDirectoryPath.setText(install_directoryPath);

      // the conf dir text field
      confTextFieldDirectory.setEditable(true);
      confTextFieldDirectory.setModel(confFieldModel);

      // the install label
      JLabel installJLabel = new JLabel();
      String installLabelMessage = JBossResource.get("INSTALLATION_DIRECTORY");
      installJLabel.setText(installLabelMessage);
      installJLabel.setDisplayedMnemonic(installLabelMessage.charAt(6));
      installJLabel.setLabelFor(installTextFieldDirectoryPath);

      // the conf label
      JLabel confJLabel = new JLabel();
      String confLabelMessage = JBossResource.get("CONFIGURATION_DIRECTORY");
      confJLabel.setText(confLabelMessage);
      confJLabel.setDisplayedMnemonic(confLabelMessage.charAt(6));
      confJLabel.setLabelFor(confTextFieldDirectory);

      // the about button
      jButtonAbout.setText(JBossResource.get("ABOUT_BOX_BUTTON"));

// ************************** start panel with install text field and install button
      JPanel installPanel = new JPanel(new GridBagLayout());
      jButtonInstallUrl.setIcon(BrowserIcons.ICON_DOTDOTDOT);
      installPanel.add(installTextFieldDirectoryPath, new GridBagConstraints(
               0, // gridx
               0, // gridy
               1, // gridwidth
               1, // gridheight
               1.0D, // weightx
               0.0D, // weighty
               GridBagConstraints.CENTER, // anchor
               GridBagConstraints.HORIZONTAL, // fill
               new Insets(0, 0, 8, 4), // insets
               0, // ipadx
               0 // ipady
            ));
      installPanel.add(jButtonInstallUrl, new GridBagConstraints(
               1, // gridx
               0, // gridy
               1, // gridwidth
               1, // gridheight
               0.0D, // weightx
               0.0D, // weighty
               GridBagConstraints.CENTER, // anchor
               GridBagConstraints.HORIZONTAL, // fill
               new Insets(0, 0, 8, 0), // insets
               0, // ipadx
               0 // ipady
            ));
// ********************* end panel with install text field and install button

// ********************* start panel with configuration text field and conf button
      JPanel confPanel = new JPanel(new GridBagLayout());
//      jButtonConfDir.setIcon(BrowserIcons.ICON_DOTDOTDOT);
      confPanel.add(confTextFieldDirectory, new GridBagConstraints(
               0, // gridx
               0, // gridy
               2, // gridwidth
               1, // gridheight
               1.0D, // weightx
               0.0D, // weighty
               GridBagConstraints.CENTER, // anchor
               GridBagConstraints.HORIZONTAL, // fill
               new Insets(0, 0, 8, 4), // insets
               0, // ipadx
               0 // ipady
            ));
//      confPanel.add(jButtonConfDir, new GridBagConstraints(
//               1, // gridx
//               0, // gridy
//               1, // gridwidth
//               1, // gridheight
//               0.0D, // weightx
//               0.0D, // weighty
//               GridBagConstraints.CENTER, // anchor
//               GridBagConstraints.HORIZONTAL, // fill
//               new Insets(0, 0, 8, 0), // insets
//               0, // ipadx
//               0 // ipady
//            ));
// ********************* end panel with configuration text field and conf button

// ************ put it all together ***********************
      aJPanel.add(installJLabel, new GridBagConstraints(
               0, // gridx
               0, // gridy
               2, // gridwidth
               1, // gridheight
               0.0D, // weightx
               0.0D, // weighty
               GridBagConstraints.WEST, // anchor
               GridBagConstraints.NONE, // fill
               new Insets(0, 0, 1, 8), // insets
               0, // ipadx
               0 // ipady
            ));

      aJPanel.add(installPanel, new GridBagConstraints(
               0, // gridx
               1, // gridy
               2, // gridwidth
               1, // gridheight
               1.0D, // weightx
               0.0D, // weighty
               GridBagConstraints.NORTH, // anchor
               GridBagConstraints.HORIZONTAL, // fill
               new Insets(0, 0, 0, 0), // insets
               0, // ipadx
               0 // ipady
            ));

      aJPanel.add(confJLabel, new GridBagConstraints(
               0, // gridx
               2, // gridy
               2, // gridwidth
               1, // gridheight
               0.0D, // weightx
               0.0D, // weighty
               GridBagConstraints.WEST, // anchor
               GridBagConstraints.NONE, // fill
               new Insets(0, 0, 1, 8), // insets
               0, // ipadx
               0 // ipady
            ));

      aJPanel.add(confPanel, new GridBagConstraints(
               0, // gridx
               3, // gridy
               2, // gridwidth
               1, // gridheight
               1.0D, // weightx
               0.0D, // weighty
               GridBagConstraints.NORTH, // anchor
               GridBagConstraints.HORIZONTAL, // fill
               new Insets(0, 0, 0, 0), // insets
               0, // ipadx
               0 // ipady
            ));

      aJPanel.add(jButtonAbout, new GridBagConstraints(
               0, // gridx
               4, // gridy
               2, // gridwidth
               1, // gridheight
               1.0D, // weightx
               0.0D, // weighty
               GridBagConstraints.CENTER, // anchor
               GridBagConstraints.NONE, // fill
               new Insets(10, 10, 10, 10), // insets
               0, // ipadx
               0 // ipady
            ));

      aJPanel.add(new JLabel(), new GridBagConstraints(
               0, // gridx
               5, // gridy
               2, // gridwidth
               2, // gridheight
               1.0D, // weightx
               0.0D, // weighty
               GridBagConstraints.CENTER, // anchor
               GridBagConstraints.BOTH, // fill
               new Insets(0, 0, 0, 0), // insets
               0, // ipadx
               0 // ipady
            ));

      aJPanel.add(new JPanel(), new GridBagConstraints(0, 6, 1, 1, 1.0D, 1.0D, 11, 1, new Insets(0, 0, 0, 0), 0, 0));

      // listen for action on button
      jButtonInstallUrl.addActionListener(this);
//      jButtonConfDir.addActionListener(this);
      jButtonAbout.addActionListener(this);
      return aJPanel;
   }

  /**
   * Test if we need to save properties
   */
  public boolean isModified()
  {
    return !getInstallPathText().equals(initialSettings.getInstallPath()) || !getConfigNameText().equals(initialSettings.getConfigName());
  }

  /**
  * Load current properties
  */
  public void readProperties()
  {
    setInstallPathText(JBossPropertyGroup.INSTALL_PATH_24.getValue());
    confTextFieldDirectory.setModel(getConfModel(JBossPropertyGroup.INSTALL_PATH_24.getValue()));
    confTextFieldDirectory.setSelectedItem(JBossPropertyGroup.CONFIGURATION_NAME_24.getValue());
    saveInitialSettings();
  }

  /**
  * Save updated properties
  */
  public void writeProperties()
  {
    if(!isModified())
    {
      return;
    }
    else
    {
      JBossSetupSettings24 jbossSetupSettings = new JBossSetupSettings24();
      jbossSetupSettings.setInstallPath(getInstallPathText());
      jbossSetupSettings.setConfigName(getConfigNameText());
      saveJBossSettings(jbossSetupSettings);
      updateJBossAppServer(jbossSetupSettings);
      return;
    }
  }

  private void updateJBossAppServer(JBossSetupSettings24 jbossSetupSettings)
  {
    AppServer anAppserver = AppServerManager.getAppServer(JBossResource.getDefaultName24());
    if(anAppserver != null && jbossSetupSettings.getInstallPath().length() > 0)
    {
      String oldUserDir = ((JBossAppServer24)anAppserver).getDefaultUserDirectory().getFile();
      String newUserDir = jbossSetupSettings.getInstallPath();
      if(!newUserDir.endsWith("/"))
      {
        newUserDir = newUserDir + "/";
      }
      newUserDir = newUserDir + "bin/";

      anAppserver.updateVmParametersWithNewSetting("user.dir", oldUserDir, newUserDir);
      anAppserver.updateClassPathWithNewHomeDirectory(jbossSetupSettings.getInstallPath());
      anAppserver.setHomeDirectory(new Url("file", jbossSetupSettings.getInstallPath()));
      anAppserver.setWorkingDirectory(new Url("file", newUserDir));
      anAppserver.setParameters(jbossSetupSettings.getConfigName());

      AppServerManager.save();
    }
  }

  /**
   * Button clic
   */
  public void actionPerformed(ActionEvent e)
  {
    if(e.getSource() == jButtonInstallUrl)
    {
      EnterpriseUtils.setTextFieldFromUrlSelection(this, installTextFieldDirectoryPath, JBossResource.get("INSTALL_FILE_CHOOSER_TITLE"));
      String temp = installTextFieldDirectoryPath.getText();
      String msg = validateInstallDirectory(temp);
      if(msg != null)
      {
        reportValidationError(jButtonInstallUrl, msg);
      }
      else
      {
        confTextFieldDirectory.setModel(getConfModel(temp));
      }
    }
    else
    {
      new AboutBox(Browser.getActiveBrowser()).show();
    }
  }

  /**
  * Do you need help ?
  */
  public HelpTopic getHelpTopic()
  {
    return JBuilderHelp.TOPIC_DAppServerSetup;
  }

  public static void saveJBossSettings(JBossSetupSettings24 jbossSetupSettings)
  {
    AppServer appserver = AppServerManager.getAppServer(JBossResource.getDefaultName24());

    JBossPropertyGroup.INSTALL_PATH_24.setValue(jbossSetupSettings.getInstallPath());
    JBossPropertyGroup.CONFIGURATION_NAME_24.setValue(jbossSetupSettings.getConfigName());
    if(appserver != null)
    {
      appserver.createLibrariesFromSetup(jbossSetupSettings.getInstallPath());
      appserver.setSetupCompleted(true);
    }
  }

  protected void setInstallPathText(String s)
  {
    installTextFieldDirectoryPath.setText(s != null ? s : "");
  }

  protected String getInstallPathText()
  {
    return installTextFieldDirectoryPath.getText().trim();
  }


  protected String getConfigNameText()
  {
    Object tmp = confTextFieldDirectory.getSelectedItem();
    if (tmp == null)
    {
      return "";
    }
    return (String)tmp;
  }

  protected ComboBoxModel getConfModel(String installDir)
  {
    if (installDir == null || installDir.trim().length() == 0)
    {
      return new DefaultComboBoxModel();
    }

    File file = new File(installDir.concat("/conf/"));
    File[] allConf = file.listFiles();
    if (allConf == null)
    {
      return new DefaultComboBoxModel();
    }
    Vector allConfString = new Vector();
    for (int i = 0; i < allConf.length; i++)
    {
      if (allConf[i].isDirectory())
      {
        allConfString.add(allConf[i].getName());
      }
    }
    return new DefaultComboBoxModel(allConfString);

  }

  protected void saveInitialSettings()
  {
    initialSettings.setInstallPath(getInstallPathText());
    initialSettings.setConfigName(getConfigNameText());
  }

  public void applySettingsToCurrentProject()
  {
    com.borland.jbuilder.node.JBProject jbproject = getProject();
    if(jbproject != null)
    {
      AppServerManager.setAppServerForProject(jbproject, JBossResource.getDefaultName24(), true);
    }
  }

  public boolean isPageValid()
  {
    if(!isModified() && !isShowing())
    {
      return true;
    }
    boolean flag = true;
    String installDirectory = getInstallPathText();
    String confName = getConfigNameText();
    if(installDirectory.length() == 0)
    {
        reportValidationError(jButtonInstallUrl, JBossResource.get("INSTALL_DIRECTORY_EMPTY"));
        flag = false;
    }

    if(flag)
    {
        String msg = validateInstallDirectory(installDirectory);
        if(msg != null)
        {
            reportValidationError(jButtonInstallUrl, msg);
            flag = false;
        }
    }

    if(flag && (confName.length() == 0))
    {
      reportValidationError(confTextFieldDirectory, JBossResource.get("CONF_NAME_EMPTY"));
      flag = false;
    }

    if(flag)
    {
        String msg = validateConfigurationName(installDirectory, confName);
        if(msg != null)
        {
            reportValidationError(confTextFieldDirectory, msg);
            flag = false;
        }
    }

    return flag;
  }

  public static String validateInstallDirectory(String installDirectory)
  {
    String s2 = null;
    File file = new File(installDirectory.concat("/bin/run.jar"));
    if(!file.exists())
    {
      s2 = AppServerSetupPropertyPage.getErrorMessageInvalidInstallNoFile("JBoss", file.getPath());
    }
    return s2;
  }

  public String validateConfigurationName(String installDirectory, String confName)
  {
    String s2 = null;
    File file = new File(installDirectory.concat("/conf/" + confName));
    if(!file.exists())
    {
      s2 = JBossResource.get("CONF_NAME_WRONG1") + confName + JBossResource.get("CONF_NAME_WRONG2") + installDirectory + "/conf" + JBossResource.get("CONF_NAME_WRONG3");
    }
    return s2;
  }
}
// eof