/*
 * Voyager JBoss OpenTool for JBuilder
 *
 * Copyright (c) 2002 Marcus Redeker, Gedoplan GmbH - Bielefeld, Germany
 *    marcus.redeker@gedoplan.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Cyrille Morvan's excellent 'Kelly JOnAS OpenTool' sources provided
 * much of the inspiration and some of the code for this OpenTool.
 *
*/
package de.gedoplan.opentools.jboss;

import com.borland.jbuilder.JBuilderHelp;
import com.borland.jbuilder.ide.SetupPropertyPage;
import com.borland.jbuilder.ide.SetupManager;
import com.borland.jbuilder.enterprise.ejb.AppServer;
import com.borland.jbuilder.enterprise.ejb.AppServerManager;
import com.borland.jbuilder.paths.PathSet;
import com.borland.jbuilder.enterprise.EnterpriseUtils;
import com.borland.jbuilder.enterprise.ejb.AppServerSetupPropertyPage;

import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.ui.UrlChooser;
import com.borland.primetime.ide.BrowserIcons;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.properties.*;
import com.borland.primetime.help.HelpTopic;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.*;


/**
 * Creates the property page which is displayed under menu Tools/Enterprise Setup
 *
 * @author <a href="mailto:marcus.redeker@gedoplan.de">Marcus Redeker (Gedoplan GmbH, Germany)</a>
 * @version 1.2
 */
public class JBossSetupPropertyPage30 extends JBossSetupPropertyPage24
{


  private JBossSetupSettings30 initialSettings;


  /**
   * Constructor
   */
  public JBossSetupPropertyPage30(Browser browser)
  {
    super(browser);
    initialSettings = new JBossSetupSettings30();
  }

  /**
   * Get description to display on top
   */
  public String getDescription()
  {
    return JBossResource.get("SERVER_DESCRIPTION30");
  }

  protected ComboBoxModel getConfModel(String installDir)
  {
    if (installDir == null || installDir.trim().length() == 0)
    {
      return new DefaultComboBoxModel();
    }
    File file = new File(installDir.concat("/server/"));
    File[] allConf = file.listFiles();
    if (allConf == null)
    {
      return new DefaultComboBoxModel();
    }
    Vector allConfString = new Vector();
    for (int i = 0; i < allConf.length; i++)
    {
      if (allConf[i].isDirectory())
      {
        allConfString.add(allConf[i].getName());
      }
    }
    return new DefaultComboBoxModel(allConfString);

  }

  /**
  * Load current properties
  */
  public void readProperties()
  {
    setInstallPathText(JBossPropertyGroup.INSTALL_PATH_30.getValue());
    confTextFieldDirectory.setModel(getConfModel(JBossPropertyGroup.INSTALL_PATH_30.getValue()));
    confTextFieldDirectory.setSelectedItem(JBossPropertyGroup.CONFIGURATION_NAME_30.getValue());
    saveInitialSettings();
  }

  /**
  * Save updated properties
  */
  public void writeProperties()
  {
    if(!isModified())
    {
      return;
    }
    else
    {
      JBossSetupSettings30 jbossSetupSettings = new JBossSetupSettings30();
      jbossSetupSettings.setInstallPath(getInstallPathText());
      jbossSetupSettings.setConfigName(getConfigNameText());
      saveJBossSettings(jbossSetupSettings);
      updateJBossAppServer(jbossSetupSettings);
      return;
    }
  }

  private void updateJBossAppServer(JBossSetupSettings30 jbossSetupSettings)
  {
    AppServer anAppserver = AppServerManager.getAppServer(JBossResource.getDefaultName30());
    if(anAppserver != null && jbossSetupSettings.getInstallPath().length() > 0)
    {
      String newWorkDir = jbossSetupSettings.getInstallPath();
      if(!newWorkDir.endsWith("/"))
      {
        newWorkDir = newWorkDir + "/";
      }
      newWorkDir = newWorkDir + "bin/";

      anAppserver.updateClassPathWithNewHomeDirectory(jbossSetupSettings.getInstallPath());
      anAppserver.setHomeDirectory(new Url("file", jbossSetupSettings.getInstallPath()));
      anAppserver.setWorkingDirectory(new Url("file", newWorkDir));
      anAppserver.setParameters("-c " + jbossSetupSettings.getConfigName());

      AppServerManager.save();
    }
  }



  public static void saveJBossSettings(JBossSetupSettings30 jbossSetupSettings)
  {
    AppServer appserver = AppServerManager.getAppServer(JBossResource.getDefaultName30());

    JBossPropertyGroup.INSTALL_PATH_30.setValue(jbossSetupSettings.getInstallPath());
    JBossPropertyGroup.CONFIGURATION_NAME_30.setValue(jbossSetupSettings.getConfigName());
    if(appserver != null)
    {
      appserver.createLibrariesFromSetup(jbossSetupSettings.getInstallPath());
      appserver.setSetupCompleted(true);
    }
  }


  public String validateConfigurationName(String installDirectory, String confName)
  {
    String s2 = null;
    File file = new File(installDirectory.concat("/server/" + confName));
    if(!file.exists())
    {
      s2 = JBossResource.get("CONF_NAME_WRONG1") + confName + JBossResource.get("CONF_NAME_WRONG2") + installDirectory + "/conf" + JBossResource.get("CONF_NAME_WRONG3");
    }
    return s2;
  }

  public void applySettingsToCurrentProject()
  {
    com.borland.jbuilder.node.JBProject jbproject = getProject();
    if(jbproject != null)
    {
      AppServerManager.setAppServerForProject(jbproject, JBossResource.getDefaultName30(), true);
    }
  }



}
// eof