/*
 * Voyager JBoss OpenTool for JBuilder
 *
 * Copyright (c) 2002 Marcus Redeker, Gedoplan GmbH - Bielefeld, Germany
 *    marcus.redeker@gedoplan.de
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Cyrille Morvan's excellent 'Kelly JOnAS OpenTool' sources provided
 * much of the inspiration and some of the code for this OpenTool.
 *
*/
package de.gedoplan.opentools.jboss;

import com.borland.jbuilder.info.JBuilderInfo;
import com.borland.jbuilder.enterprise.ejb.EjbPropertyElement;
import com.borland.jbuilder.enterprise.ejb.AppServer;
import com.borland.jbuilder.enterprise.ejb.AppServerTargeting;
import com.borland.jbuilder.enterprise.ejb.EjbReference;
import com.borland.jbuilder.enterprise.ejb.DeploymentDescriptor;
import com.borland.jbuilder.node.EJBGRPFileNode;
import com.borland.jbuilder.build.BuildReport;
import com.borland.primetime.ide.MessageView;
import com.borland.primetime.ide.MessageCategory;


/**
 * This class is setting the target for J2EE EJB applications to be the JBoss appserver.
 * It trigers the generating of the JBoss deployment descriptors.
 *
 * @author <a href="mailto:marcus.redeker@gedoplan.de">Marcus Redeker (Gedoplan GmbH, Germany)</a>
 * @version 1.2
 */
public class JBossTargeting24 extends AppServerTargeting
{
  private boolean a;

  public JBossTargeting24()
  {
  }

  public static void initOpenTool(byte byte0, byte byte1)
  {
    if(JBuilderInfo.isEnterpriseEnabled())
    {
      AppServer.registerTargeting(JBossResource.get("SERVER_NAME"), JBossResource.get("SERVER_VERSION24"), new JBossTargeting24());
    }
  }

  public boolean hasEjbProperties(EjbReference p0)
  {
    return true;
  }

  public EjbPropertyElement[] getEjbProperties(EjbReference parm1)
  {
    return JBossDescriptorConversion24.getPropertyNamesToSurface(parm1);
  }

  public void verifyDeploymentDescriptors(MessageView messageview, MessageCategory messagecategory, DeploymentDescriptor adeploymentdescriptor[], EJBGRPFileNode ejbgrpfilenode)
  {
    try
    {
      JBossDescriptorConversion24 ddConversion = new JBossDescriptorConversion24(adeploymentdescriptor, ejbgrpfilenode, null);
      ddConversion.verifyDeploymentDescriptors(messageview, messagecategory);
    }
    catch(Exception exception) { }
  }

  public DeploymentDescriptor[] updateDeploymentDescriptors(DeploymentDescriptor adeploymentdescriptor[], EJBGRPFileNode ejbgrpfilenode, BuildReport buildreport)
  {
    if(!a)
    {
      a = true;
      try
      {
        JBossDescriptorConversion24 ddConversion = new JBossDescriptorConversion24(adeploymentdescriptor, ejbgrpfilenode, buildreport);
        DeploymentDescriptor[] aDeploymentDescriptor = ddConversion.convert(true, true);
        return aDeploymentDescriptor;
      }
      catch(Exception exception)
      {
        exception.printStackTrace();
      }
      finally
      {
        a = false;
      }
    }
    return null;
  }

}