/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.javadoc;

import com.borland.jbuilder.node.JBProject;
import com.borland.jbuilder.node.JavaFileNode;
import com.borland.jbuilder.node.PackageNode;
import com.borland.primetime.Command;
import com.borland.primetime.PrimeTime;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.Project;
import com.borland.primetime.vfs.InvalidUrlException;
import com.borland.primetime.vfs.Url;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;

public class JavadocCommand
implements Command {
    private static final String DESCR = "Run javadoc on the nominated project";
    private static final String LEADER = "Javadoc Command: ";
    private static final String USAGE = "  Runs the javadoc utility on the nominated project.\n  If you specify options, replace initial hyphens (-) with underscores (_),\n  and double quotes (\") with single ones (').\n\n    -javadoc [javadoc options]... project.jpx\n\n  For example:\n\n    -javadoc _header 'My new project' project.jpx";
    private static final String VERSION = "1.0";

    private void addSourcePaths(ArrayList command, String sourceBase, Node node) {
        Node[] nodes = node.getChildren();
        int index = 0;
        while (index < nodes.length) {
            if (nodes[index] instanceof JavaFileNode) {
                File file = ((JavaFileNode)nodes[index]).getUrl().getFileObject();
                if (file != null) {
                    command.add(file.getAbsolutePath());
                }
            } else if (nodes[index] instanceof PackageNode) {
                command.add(sourceBase + ((PackageNode)nodes[index]).getName().replace('.', File.separatorChar) + File.separatorChar + "*.java");
            }
            this.addSourcePaths(command, sourceBase, nodes[index]);
            ++index;
        }
    }

    private String getClassPath(JBProject project) {
        StringBuffer classPath = new StringBuffer(".");
        Url[] urls = project.getPaths().getFullClassPath();
        if (urls != null) {
            int index = 0;
            while (index < urls.length) {
                classPath.append(File.pathSeparator).append(urls[index].getFileObject().getAbsolutePath());
                ++index;
            }
        }
        return classPath.toString();
    }

    public String getCommandDescription() {
        return DESCR;
    }

    private String getJavadocPath(JBProject project) {
        File javadocPath = project.getPaths().getJDKPathSet().getHomePath().getFileObject();
        if (javadocPath == null) {
            System.err.println("Unable to locate project's Java VM");
            System.exit(1);
        }
        return javadocPath.getAbsolutePath() + File.separatorChar + "bin" + File.separatorChar + "javadoc";
    }

    private String getSourceBase(JBProject project) {
        File file;
        Url[] paths = project.getPaths().getSourcePath();
        if (paths == null || paths.length == 0) {
            System.err.println("Unable to locate project's source path");
            System.exit(1);
        }
        if ((file = paths[0].getFileObject()) == null) {
            System.err.println("Unable to locate project's source path");
            System.exit(1);
        }
        return file.getAbsolutePath() + File.separatorChar;
    }

    public static void initOpenTool(byte majorVersion, byte minorVersion) {
        if (majorVersion != 4) {
            return;
        }
        PrimeTime.registerCommand((String)"javadoc", (Command)new JavadocCommand());
        if (PrimeTime.isVerbose()) {
            System.out.println("Loaded javadoc command v1.0");
            System.out.println("Written by Keith Wood (kbwood@iprimus.com.au)");
        }
    }

    public void invokeCommand(String[] params) {
        if (params.length == 0) {
            System.err.println("Javadoc Command:   Runs the javadoc utility on the nominated project.\n  If you specify options, replace initial hyphens (-) with underscores (_),\n  and double quotes (\") with single ones (').\n\n    -javadoc [javadoc options]... project.jpx\n\n  For example:\n\n    -javadoc _header 'My new project' project.jpx");
            System.exit(1);
        }
        ArrayList<String> command = new ArrayList<String>();
        int index = 0;
        while (index < params.length - 1) {
            if (params[index].charAt(0) == '_') {
                command.add("-" + params[index].substring(1));
            } else {
                command.add(params[index].replace('\'', '\"'));
            }
            ++index;
        }
        File file = new File(params[params.length - 1]);
        if (!file.exists()) {
            System.err.println("The file '" + file.getAbsolutePath() + "' does not exist");
            System.exit(1);
        }
        try {
            Project project = Project.getProject((Url)new Url(file));
            if (!(project instanceof JBProject)) {
                throw new InvalidUrlException();
            }
            this.runJavadoc(command, (JBProject)project);
        }
        catch (InvalidUrlException ex) {
            System.err.println("The file '" + file.getAbsolutePath() + "' is not a valid JBuilder project");
            System.exit(1);
        }
        PrimeTime.registerCommand(null, null);
    }

    private void printCommand(ArrayList command) {
        StringBuffer buffer = new StringBuffer(">");
        int index = 0;
        while (index < command.size()) {
            buffer.append(" ").append((String)command.get(index));
            ++index;
        }
        System.out.println();
        System.out.println(buffer.toString());
        System.out.println();
    }

    public void printCommandHelp(PrintStream out) {
        out.println(USAGE);
    }

    private void runJavadoc(ArrayList command, JBProject project) {
        if (command.size() == 0) {
            String title;
            String version;
            command.add("-protected");
            String author = project.getProperty("Author");
            if (author != null && author.length() > 0) {
                command.add("-author");
            }
            if ((version = project.getProperty("Version")) != null && version.length() > 0) {
                command.add("-version");
            }
            if ((title = project.getProperty("Title")) != null && title.length() > 0) {
                command.add("-doctitle");
                command.add("\"" + title + "\"");
            }
        }
        command.add(0, this.getJavadocPath(project));
        Url[] urls = project.getPaths().getDocPath();
        if (urls != null && urls.length > 0) {
            command.add("-d");
            command.add(urls[0].getFileObject().getAbsolutePath());
        }
        command.add("-classpath");
        command.add(this.getClassPath(project));
        this.addSourcePaths(command, this.getSourceBase(project), (Node)project);
        this.printCommand(command);
        try {
            Process process = Runtime.getRuntime().exec(command.toArray(new String[0]));
            InputStream in = process.getInputStream();
            byte[] buffer = new byte[1024];
            int count = 0;
            while ((count = in.read(buffer)) != -1) {
                System.out.write(buffer, 0, count);
            }
        }
        catch (IOException ioe) {
            System.err.println("Error during processing");
            ioe.printStackTrace();
        }
    }

    public boolean takesCommandArguments() {
        return true;
    }
}

