/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.layouts;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import wood.keith.opentools.layouts.AbstractLayout;

public class BorderCornerLayout
extends AbstractLayout
implements LayoutManager2,
Serializable {
    static final String[] AREAS = new String[]{"NorthWest", "North", "NorthEast", "West", "Center", "East", "SouthWest", "South", "SouthEast"};
    public static final String CENTER = "Center";
    public static final String EAST = "East";
    public static final String NORTH = "North";
    public static final String NORTHEAST = "NorthEast";
    public static final String NORTHWEST = "NorthWest";
    public static final String SOUTH = "South";
    public static final String SOUTHEAST = "SouthEast";
    public static final String SOUTHWEST = "SouthWest";
    public static final String WEST = "West";
    protected Component center;
    protected boolean cornersContribute = true;
    protected Component east;
    protected Component north;
    protected Component northeast;
    protected Component northwest;
    protected Component south;
    protected Component southeast;
    protected Component southwest;
    protected Component west;

    public BorderCornerLayout(int hgap, int vgap) {
        this.setHgap(hgap);
        this.setVgap(vgap);
    }

    public BorderCornerLayout() {
        this(0, 0);
    }

    public void addLayoutComponent(Component comp, Object constraint) {
        if (constraint == CENTER || constraint == null) {
            this.center = comp;
        }
        if (constraint == NORTH) {
            this.north = comp;
        }
        if (constraint == SOUTH) {
            this.south = comp;
        }
        if (constraint == WEST) {
            this.west = comp;
        }
        if (constraint == EAST) {
            this.east = comp;
        }
        if (constraint == NORTHEAST) {
            this.northeast = comp;
        }
        if (constraint == NORTHWEST) {
            this.northwest = comp;
        }
        if (constraint == SOUTHEAST) {
            this.southeast = comp;
        }
        if (constraint == SOUTHWEST) {
            this.southwest = comp;
        }
    }

    public boolean getCornersContribute() {
        return this.cornersContribute;
    }

    private int getHorizSize(Component comp, boolean preferred) {
        return comp == null ? 0 : (int)this.getPrefOrMinSize(comp, preferred).getWidth();
    }

    private Dimension getPrefOrMinSize(Component comp, boolean preferred) {
        return preferred ? comp.getPreferredSize() : comp.getMinimumSize();
    }

    private int getVertSize(Component comp, boolean preferred) {
        return comp == null ? 0 : (int)this.getPrefOrMinSize(comp, preferred).getHeight();
    }

    public void layoutContainer(Container container) {
        Dimension size = container.getSize();
        Insets insets = container.getInsets();
        int northHeight = this.getVertSize(this.north, true);
        int southHeight = this.getVertSize(this.south, true);
        int eastWidth = this.getHorizSize(this.east, true);
        int westWidth = this.getHorizSize(this.west, true);
        if (this.cornersContribute || northHeight == 0) {
            northHeight = Math.max(northHeight, Math.max(this.getVertSize(this.northwest, true), this.getVertSize(this.northeast, true)));
        }
        if (this.cornersContribute || southHeight == 0) {
            southHeight = Math.max(southHeight, Math.max(this.getVertSize(this.southwest, true), this.getVertSize(this.southeast, true)));
        }
        if (this.cornersContribute || eastWidth == 0) {
            eastWidth = Math.max(eastWidth, Math.max(this.getHorizSize(this.northeast, true), this.getHorizSize(this.southeast, true)));
        }
        if (this.cornersContribute || westWidth == 0) {
            westWidth = Math.max(westWidth, Math.max(this.getHorizSize(this.northwest, true), this.getHorizSize(this.southwest, true)));
        }
        int x0 = insets.left;
        int x1 = x0 + westWidth + (westWidth == 0 ? 0 : this.hgap);
        int x2 = size.width - insets.right - eastWidth;
        int y0 = insets.top;
        int y1 = y0 + northHeight + (northHeight == 0 ? 0 : this.vgap);
        int y2 = size.height - insets.bottom - southHeight;
        int w = x2 - x1 - (eastWidth == 0 ? 0 : this.hgap);
        int h = y2 - y1 - (southHeight == 0 ? 0 : this.vgap);
        if (this.northwest != null) {
            this.northwest.setBounds(x0, y0, westWidth, northHeight);
        }
        if (this.north != null) {
            this.north.setBounds(x1, y0, w, northHeight);
        }
        if (this.northeast != null) {
            this.northeast.setBounds(x2, y0, eastWidth, northHeight);
        }
        if (this.west != null) {
            this.west.setBounds(x0, y1, westWidth, h);
        }
        if (this.center != null) {
            this.center.setBounds(x1, y1, w, h);
        }
        if (this.east != null) {
            this.east.setBounds(x2, y1, eastWidth, h);
        }
        if (this.southwest != null) {
            this.southwest.setBounds(x0, y2, westWidth, southHeight);
        }
        if (this.south != null) {
            this.south.setBounds(x1, y2, w, southHeight);
        }
        if (this.southeast != null) {
            this.southeast.setBounds(x2, y2, eastWidth, southHeight);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("BorderCornerLayout Demonstration");
        frame.getContentPane().setLayout(new BorderLayout());
        BorderCornerLayout layout = new BorderCornerLayout(9, 4);
        JPanel panel = new JPanel(layout);
        JButton swButton = new JButton(SOUTHWEST);
        swButton.setPreferredSize(new Dimension(150, 90));
        panel.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
        panel.add(CENTER, new JButton(CENTER));
        panel.add(NORTH, new JButton(NORTH));
        panel.add(SOUTH, new JButton(SOUTH));
        panel.add(WEST, new JButton(WEST));
        panel.add(EAST, new JButton(EAST));
        panel.add(NORTHEAST, new JButton(NORTHEAST));
        panel.add(NORTHWEST, new JButton(NORTHWEST));
        panel.add(SOUTHEAST, new JButton(SOUTHEAST));
        panel.add(SOUTHWEST, swButton);
        frame.getContentPane().add(panel);
        ((Component)frame).setSize(500, 300);
        ((Component)frame).setVisible(true);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.prefOrMinLayoutSize(container, false);
    }

    private Dimension prefOrMinLayoutSize(Container container, boolean preferred) {
        Insets insets = container.getInsets();
        int northHeight = this.getVertSize(this.north, preferred);
        int southHeight = this.getVertSize(this.south, preferred);
        int eastWidth = this.getHorizSize(this.east, preferred);
        int westWidth = this.getHorizSize(this.west, preferred);
        int centerHeight = Math.max(this.getVertSize(this.center, preferred), Math.max(this.getVertSize(this.west, preferred), this.getVertSize(this.east, preferred)));
        int centerWidth = Math.max(this.getHorizSize(this.center, preferred), Math.max(this.getHorizSize(this.north, preferred), this.getHorizSize(this.south, preferred)));
        if (this.cornersContribute || northHeight == 0) {
            northHeight = Math.max(northHeight, Math.max(this.getVertSize(this.northwest, preferred), this.getVertSize(this.northeast, preferred)));
        }
        if (this.cornersContribute || southHeight == 0) {
            southHeight = Math.max(southHeight, Math.max(this.getVertSize(this.southwest, preferred), this.getVertSize(this.southeast, preferred)));
        }
        if (this.cornersContribute || eastWidth == 0) {
            eastWidth = Math.max(eastWidth, Math.max(this.getHorizSize(this.northeast, preferred), this.getHorizSize(this.southeast, preferred)));
        }
        if (this.cornersContribute || westWidth == 0) {
            westWidth = Math.max(westWidth, Math.max(this.getHorizSize(this.northwest, preferred), this.getHorizSize(this.southwest, preferred)));
        }
        int height = northHeight + centerHeight + southHeight;
        int width = westWidth + centerWidth + eastWidth;
        return new Dimension(insets.left + insets.right + width + (westWidth == 0 ? 0 : this.hgap) + (eastWidth == 0 ? 0 : this.hgap), insets.top + insets.bottom + height + (northHeight == 0 ? 0 : this.vgap) + (southHeight == 0 ? 0 : this.vgap));
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.prefOrMinLayoutSize(container, true);
    }

    public void removeLayoutComponent(Component comp) {
        if (this.center == comp) {
            this.center = null;
        }
        if (this.north == comp) {
            this.north = null;
        }
        if (this.south == comp) {
            this.south = null;
        }
        if (this.west == comp) {
            this.west = null;
        }
        if (this.east == comp) {
            this.east = null;
        }
        if (this.northeast == comp) {
            this.northeast = null;
        }
        if (this.northwest == comp) {
            this.northwest = null;
        }
        if (this.southeast == comp) {
            this.southeast = null;
        }
        if (this.southwest == comp) {
            this.southwest = null;
        }
    }

    public void setCornersContribute(boolean value) {
        this.cornersContribute = value;
    }
}

