/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.layouts;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import wood.keith.opentools.layouts.AbstractLayout;

public class CenterLayout
extends AbstractLayout
implements LayoutManager2,
Serializable {
    public static final String CENTER = "Center";
    public static final String EAST = "East";
    public static final int HORIZONTAL = 1;
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final int VERTICAL = 0;
    public static final String WEST = "West";
    protected Component center;
    protected Component east;
    protected int hgap;
    protected Component north;
    protected int orientation;
    protected Component south;
    protected int vgap;
    protected Component west;

    public CenterLayout(int hgap, int vgap, int orientation) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.orientation = orientation;
    }

    public CenterLayout(int hgap, int vgap) {
        this(hgap, vgap, 0);
    }

    public CenterLayout(int orientation) {
        this(0, 0, orientation);
    }

    public CenterLayout() {
        this(0, 0, 0);
    }

    public void addLayoutComponent(Component comp, Object constraint) {
        if (constraint == null) {
            this.center = comp;
        }
        if (constraint == CENTER) {
            this.center = comp;
        }
        if (constraint == NORTH) {
            this.north = comp;
        }
        if (constraint == SOUTH) {
            this.south = comp;
        }
        if (constraint == WEST) {
            this.west = comp;
        }
        if (constraint == EAST) {
            this.east = comp;
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void layoutContainer(Container container) {
        Dimension size = container.getSize();
        Insets insets = container.getInsets();
        Dimension centerSize = this.center == null ? new Dimension(0, 0) : this.center.getPreferredSize();
        int width = size.width - (insets.left + insets.right);
        int height = size.height - (insets.top + insets.bottom);
        int x = insets.left;
        int y = insets.top;
        int w = centerSize.width;
        int h = centerSize.height;
        int x0 = insets.left;
        int y0 = insets.right;
        int x1 = (x += (width - w) / 2) - this.hgap;
        int y1 = (y += (height - h) / 2) - this.vgap;
        int x2 = x + w + this.hgap;
        int y2 = y + h + this.hgap;
        int x3 = size.width - insets.right;
        int y3 = size.height - insets.bottom;
        if (this.center != null) {
            this.center.setBounds(x, y, w, h);
        }
        if (this.orientation == 0) {
            if (this.west != null) {
                this.west.setBounds(x0, y0, x1 - x0, y3 - y0);
            }
            if (this.east != null) {
                this.east.setBounds(x2, y0, x3 - x2, y3 - y0);
            }
            if (this.north != null) {
                this.north.setBounds(x, y0, w, y1 - y0);
            }
            if (this.south != null) {
                this.south.setBounds(x, y2, w, y3 - y2);
            }
        } else {
            if (this.north != null) {
                this.north.setBounds(x0, y0, x3 - x0, y1 - y0);
            }
            if (this.south != null) {
                this.south.setBounds(x0, y2, x3 - x0, y3 - y2);
            }
            if (this.west != null) {
                this.west.setBounds(x0, y, x1 - x0, h);
            }
            if (this.east != null) {
                this.east.setBounds(x2, y, x3 - x2, h);
            }
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("BorderLayout Demonstration");
        frame.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout(9, 9));
        panel.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
        JButton center = new JButton(CENTER);
        center.setPreferredSize(new Dimension(100, 100));
        panel.add(CENTER, center);
        panel.add(NORTH, new JButton(NORTH));
        panel.add(SOUTH, new JButton(SOUTH));
        panel.add(WEST, new JButton(WEST));
        panel.add(EAST, new JButton(EAST));
        frame.getContentPane().add(panel);
        ((Component)frame).setSize(400, 300);
        ((Component)frame).setVisible(true);
    }

    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension centerSize = this.center == null ? new Dimension(0, 0) : this.center.getPreferredSize();
        Dimension westSize = new Dimension(0, 0);
        Dimension eastSize = new Dimension(0, 0);
        Dimension northSize = new Dimension(0, 0);
        Dimension southSize = new Dimension(0, 0);
        if (this.west != null) {
            westSize = this.west.getMinimumSize();
        }
        if (this.east != null) {
            eastSize = this.east.getMinimumSize();
        }
        if (this.north != null) {
            northSize = this.north.getMinimumSize();
        }
        if (this.south != null) {
            southSize = this.south.getMinimumSize();
        }
        int height = 0;
        int width = 0;
        int insetsWidth = insets.left + insets.right;
        int insetsHeight = insets.top + insets.bottom;
        if (this.orientation == 0) {
            height = northSize.height + centerSize.height + southSize.height;
            width = westSize.width + centerSize.width + eastSize.width;
            height = Math.max(westSize.width, height);
            height = Math.max(eastSize.width, height);
        } else {
            height = northSize.height + centerSize.height + southSize.height;
            width = westSize.width + centerSize.width + eastSize.width;
            width = Math.max(northSize.width, width);
            width = Math.max(southSize.width, width);
        }
        return new Dimension(insetsWidth + width, insetsHeight + height);
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension centerSize = this.center == null ? new Dimension(0, 0) : this.center.getPreferredSize();
        Dimension westSize = new Dimension(0, 0);
        Dimension eastSize = new Dimension(0, 0);
        Dimension northSize = new Dimension(0, 0);
        Dimension southSize = new Dimension(0, 0);
        if (this.west != null) {
            westSize = this.west.getPreferredSize();
        }
        if (this.east != null) {
            eastSize = this.east.getPreferredSize();
        }
        if (this.north != null) {
            northSize = this.north.getPreferredSize();
        }
        if (this.south != null) {
            southSize = this.south.getPreferredSize();
        }
        int height = 0;
        int width = 0;
        int insetsWidth = insets.left + insets.right;
        int insetsHeight = insets.top + insets.bottom;
        if (this.orientation == 0) {
            height = northSize.height + centerSize.height + southSize.height;
            width = westSize.width + centerSize.width + eastSize.width;
            height = Math.max(westSize.width, height);
            height = Math.max(eastSize.width, height);
        } else {
            height = northSize.height + centerSize.height + southSize.height;
            width = westSize.width + centerSize.width + eastSize.width;
            width = Math.max(northSize.width, width);
            width = Math.max(southSize.width, width);
        }
        return new Dimension(insetsWidth + width, insetsHeight + height);
    }

    public void removeLayoutComponent(Component comp) {
        if (this.center == comp) {
            this.center = null;
        }
        if (this.north == comp) {
            this.north = null;
        }
        if (this.south == comp) {
            this.south = null;
        }
        if (this.west == comp) {
            this.west = null;
        }
        if (this.east == comp) {
            this.east = null;
        }
    }

    public void setOrientation(int value) {
        if (value == 0 || value == 1) {
            this.orientation = value;
        }
    }
}

