package wood.keith.opentools.layouts;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

/**
 * A property editor for the constraints for the BorderCornerLayout.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  30 August 2001
 */
public class BorderCornerLayoutPropertyEditor implements PropertyEditor {

  private String value;
  private PropertyChangeSupport listeners;

  public BorderCornerLayoutPropertyEditor() {
    listeners = new PropertyChangeSupport(this);
  }

  /**
   * Set the current constraint value and
   * notify interested parties of the change.
   *
   * @param  value  the new constraint value
   */
  public void setValue(Object value) {
    String oldValue = this.value;
    this.value = (String)value;
    listeners.firePropertyChange(new PropertyChangeEvent(
      this, "BorderCornerLayoutConstraint", oldValue, this.value));
  }

  /**
   * Retrieve the current constraint value.
   *
   * @return  the constraint value
   */
  public Object getValue() {
    return value;
  }

  /**
   * This property editor doesn't do its own painting.
   */
  public boolean isPaintable() {
    return false;
  }

  public void paintValue(Graphics gfx, Rectangle box) {
    // Do nothing
  }

  /**
   * When using this constraint value in code, use this text instead.
   *
   * @return  the Java code for this constraint
   */
  public String getJavaInitializationString() {
    return "BorderCornerLayout." + value.toUpperCase();
  }

  public String getAsText() {
    return value;
  }

  public void setAsText(String text) throws java.lang.IllegalArgumentException {
    for (int index = 0; index < BorderCornerLayout.AREAS.length; index++) {
      if (BorderCornerLayout.AREAS[index].equals(text)) {
        value = text;
        return;
      }
    }
    throw new IllegalArgumentException(text);
  }

  /**
   * Retrieve the list of possible values.
   *
   * @return  an array of possible values for the constraint
   */
  public String[] getTags() {
    return BorderCornerLayout.AREAS;
  }

  /**
   * There is no customised editor for this property.
   */
  public boolean supportsCustomEditor() {
    return false;
  }

  public Component getCustomEditor() {
    return null;
  }

  public void addPropertyChangeListener(PropertyChangeListener listener) {
    listeners.addPropertyChangeListener(listener);
  }

  public void removePropertyChangeListener(PropertyChangeListener listener) {
    listeners.removePropertyChangeListener(listener);
  }
}
