package wood.keith.opentools.layouts;

import com.borland.jbuilder.designer.ui.BorderLayoutAssistant;
import com.borland.jbuilder.designer.ui.UIDesigner;
import com.borland.primetime.PrimeTime;

/**
 * Reuse the BorderLayout assistant for the CenterLayout.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  30 August 2001
 */
public class CenterLayoutAssistant {

  /**
   * Register the assistant, which also makes the associated layout
   * available in the drop-down box in the designer.
   *
   * @param  majorVersion  the major version of the current OpenTools API
   * @param  minorVersion  the minor version of the current OpenTools API
   */
  public static void initOpenTool(byte majorVersion, byte minorVersion) {
    if (majorVersion != PrimeTime.CURRENT_MAJOR_VERSION) {
      return;
    }
    UIDesigner.registerAssistant(BorderLayoutAssistant.class,
      "wood.keith.opentools.layouts.CenterLayout", true);
    if (PrimeTime.isVerbose()) {
      System.out.println("Loaded CenterLayoutAssistant");
      System.out.println("Written by Keith Wood (kbwood@iprimus.com.au)");
    }
  }
}
