package wood.keith.opentools.otrunner;

import java.io.File;
import javax.swing.JOptionPane;

import com.borland.primetime.ui.ListPanel;
import com.borland.primetime.vfs.FileFilesystem;
import com.borland.primetime.vfs.InvalidUrlException;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.ui.UrlChooser;

/**
 * A list of directories.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  22 June 2002
 */
public class DirectoryListPanel extends ListPanel {

  private static final String TITLE = "Scan directory";

  /**
   * Make adding an element public.
   *
   * @param  obj  is the new element to add
   */
  public void addListElement(Object obj) {
    super.addListElement(obj);
  }

  /**
   * Delete all entries in the list.
   */
  public void clear() {
    for (int index = getList().size() - 1; index >= 0; index--) {
      selectValue(getList().get(index));
      removeSelectedListElements();
    }
  }

  /**
   * Update the given value in the list.
   *
   * @param  value  the element to amend
   * @return  the updated element, or null if cancelled
   */
  protected Object editElement(Object value) {
    Url url = null;
    if (value != null) {
      url = new Url(new File((String)value));
    }
    url = UrlChooser.promptForDir(this, url, TITLE);
    if (url == null) {
      return null;
    }
    if (url.getProtocol() != FileFilesystem.PROTOCOL) {
      JOptionPane.showMessageDialog(this,
        "Only normal file system directories can be selected",
        "Run - OpenTool", JOptionPane.WARNING_MESSAGE);
      return null;
    }
    return url.getFile();
  }

  /**
   * Ask for a new element to add.
   *
   * @return  the new element, or null if cancelled
   */
  protected Object promptForElement() {
    return editElement(null);
  }
}
