/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.otnode;

import com.borland.jbuilder.jot.JotClass;
import com.borland.jbuilder.jot.JotExpression;
import com.borland.jbuilder.jot.JotExpressionStatement;
import com.borland.jbuilder.jot.JotFile;
import com.borland.jbuilder.jot.JotMethodSource;
import com.borland.jbuilder.jot.JotPackages;
import com.borland.jbuilder.jot.JotPrimitiveClass;
import com.borland.jbuilder.jot.JotStatement;
import com.borland.jbuilder.node.JBProject;
import com.borland.jbuilder.node.JavaFileNode;
import com.borland.jbuilder.node.PackageNode;
import com.borland.jbuilder.paths.ProjectPathSet;
import com.borland.primetime.help.HelpManager;
import com.borland.primetime.help.HelpTopic;
import com.borland.primetime.help.ZipHelpBook;
import com.borland.primetime.help.ZipHelpTopic;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Node;
import com.borland.primetime.personality.Personality;
import com.borland.primetime.util.Streams;
import com.borland.primetime.util.VetoException;
import com.borland.primetime.vfs.InvalidUrlException;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.wizard.BasicWizard;
import com.borland.primetime.wizard.Wizard;
import com.borland.primetime.wizard.WizardAction;
import com.borland.primetime.wizard.WizardHost;
import com.borland.primetime.wizard.WizardManager;
import com.borland.primetime.wizard.WizardPage;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import wood.keith.opentools.otnode.OTManifestWizardPage1;
import wood.keith.opentools.otnode.OTPersonality;
import wood.keith.opentools.otnode.OTScanner;

public class OTManifestWizard
extends BasicWizard {
    private static final String TITLE = "OpenTools Manifest";
    public static final WizardAction WIZARD_Classes_OpenTools = new WizardAction("OpenTools Manifest", '\u0000', "Generate an OpenTools manifest file for this project", new ImageIcon(ClassLoader.getSystemResource((class$wood$keith$opentools$otnode$OTManifestWizard == null ? (class$wood$keith$opentools$otnode$OTManifestWizard = OTManifestWizard.class$("wood.keith.opentools.otnode.OTManifestWizard")) : class$wood$keith$opentools$otnode$OTManifestWizard).getName().replace('.', '/') + ".gif")), null, false, null){

        protected Wizard createWizard() {
            return new OTManifestWizard();
        }

        public Personality[] getPersonalities() {
            return OTPersonality.PERSONALITIES;
        }

        public void update(Object source) {
            Browser browser = Browser.findBrowser((Object)source);
            ((AbstractAction)((Object)this)).setEnabled(browser != null && browser.getActiveProject() != null);
        }
    };
    private static Integer _archiverIndex;
    private static Integer _buildIndex;
    private static Integer _coreIndex;
    private static Integer _designerIndex;
    private static Integer _docletIndex;
    private static Integer _editorIndex;
    private static Integer _nodeIndex;
    private static Integer _serversIndex;
    private static Integer _testIndex;
    private Map _tools = null;
    private static Integer _uiIndex;
    private static Integer _urlChooserIndex;
    private static Integer _vfsIndex;
    private static Integer _wizardIndex;
    private OTManifestWizardPage1 _wizardPage1 = null;
    static /* synthetic */ Class class$wood$keith$opentools$otnode$OTManifestWizard;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static FileNode createNode(JBProject project, String fileName) throws InvalidUrlException {
        Url filePath = new Url(new File(project.getPaths().getWorkingDirectory().getFullName() + "/" + fileName));
        FileNode newNode = project.getNode(filePath);
        newNode.setParent((Node)project);
        return newNode;
    }

    private static Integer findCategory(String name) {
        return new Integer(Arrays.binarySearch(OTScanner.KEYWORDS, name));
    }

    protected void finish() throws VetoException {
        if (this._tools.size() == 0) {
            return;
        }
        Browser browser = this.wizardHost.getBrowser();
        JBProject project = (JBProject)browser.getProjectView().getActiveProject();
        try {
            FileNode textNode = OTManifestWizard.createNode(project, "classes.opentools");
            StringBuffer buffer = new StringBuffer();
            Map tools = this._wizardPage1.getTools();
            if (this._wizardPage1.isMerging()) {
                this.loadCategories(textNode, tools);
            }
            Map categories = this.getCategories(tools);
            Iterator iter = categories.keySet().iterator();
            while (iter.hasNext()) {
                String category = (String)iter.next();
                ArrayList classes = (ArrayList)categories.get(category);
                String prefix = category + ": ";
                int index = 0;
                while (index < classes.size()) {
                    buffer.append(prefix).append(classes.get(index)).append("\n");
                    prefix = "  ";
                    ++index;
                }
            }
            textNode.getBuffer().setContent(buffer.toString().getBytes());
            textNode.save();
            browser.setActiveNode((Node)textNode, true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.wizardHost.getDialogParent(), ex.getMessage(), TITLE, 0);
        }
    }

    private Map getCategories(Map tools) {
        TreeMap categories = new TreeMap();
        Iterator iter = tools.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String category = (String)entry.getValue();
            ArrayList classes = (ArrayList)categories.get(category);
            if (classes == null) {
                classes = new ArrayList();
                categories.put(category, classes);
            }
            classes.add(entry.getKey());
        }
        return categories;
    }

    public void help(WizardPage page, WizardHost host) {
        HelpManager.showHelp((HelpTopic)new ZipHelpTopic(new ZipHelpBook("OpenToolsNodeDoc.jar"), ((Object)((Object)this)).getClass().getName().replace('.', '/') + ".html"), (Component)page.getPageComponent(host));
    }

    public static void initOpenTool(byte majorVersion, byte minorVersion) {
        if (majorVersion != 4) {
            return;
        }
        WizardManager.registerWizardAction((WizardAction)WIZARD_Classes_OpenTools);
        _archiverIndex = OTManifestWizard.findCategory("Archiver");
        _buildIndex = OTManifestWizard.findCategory("Build");
        _coreIndex = OTManifestWizard.findCategory("Core");
        _designerIndex = OTManifestWizard.findCategory("Designer");
        _docletIndex = OTManifestWizard.findCategory("Doclet");
        _editorIndex = OTManifestWizard.findCategory("Editor");
        _nodeIndex = OTManifestWizard.findCategory("Node");
        _serversIndex = OTManifestWizard.findCategory("Servers");
        _testIndex = OTManifestWizard.findCategory("TestRunner");
        _uiIndex = OTManifestWizard.findCategory("UI");
        _urlChooserIndex = OTManifestWizard.findCategory("UrlChooser");
        _vfsIndex = OTManifestWizard.findCategory("VFS");
        _wizardIndex = OTManifestWizard.findCategory("Wizard");
    }

    public WizardPage invokeWizard(WizardHost host) {
        Browser browser = host.getBrowser();
        JBProject project = (JBProject)browser.getActiveProject();
        this._tools = this.scanProjectForTools(project);
        this.setWizardTitle(TITLE);
        this._wizardPage1 = new OTManifestWizardPage1(this, this._tools);
        this.addWizardPage((WizardPage)this._wizardPage1);
        return super.invokeWizard(host);
    }

    private void loadCategories(FileNode node, Map tools) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Streams.copy((InputStream)node.getInputStream(), (OutputStream)out);
        StringTokenizer tokens = new StringTokenizer(out.toString());
        String category = null;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.charAt(token.length() - 1) == ':') {
                category = token.substring(0, token.length() - 1);
                continue;
            }
            if (tools.get(token) != null) continue;
            tools.put(token, category);
        }
    }

    protected static Url makeFileUrl(JBProject project, String packageName, String fileName) {
        try {
            ProjectPathSet paths = project.getPaths();
            Url[] sourcePaths = paths.getSourcePath();
            String projectPath = "";
            if (sourcePaths.length > 0) {
                projectPath = sourcePaths[0].getFile();
            }
            String dirName = projectPath;
            if (packageName != null && packageName.length() > 0) {
                dirName = dirName + '/' + packageName.replace('.', '/');
            }
            String filePath = dirName + '/' + fileName;
            File newFile = new File(filePath);
            return new Url(newFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected void scanFileForTools(JBProject project, JavaFileNode fileNode, Map tools) {
        JotPackages jpackages = project.getJotPackages();
        JotFile jfile = jpackages.getFile(fileNode.getUrl());
        JotClass[] jclasses = jfile.getClasses();
        int index = 0;
        while (index < jclasses.length) {
            JotMethodSource jmethod = (JotMethodSource)jclasses[index].getDeclaredMethod("initOpenTool", new JotClass[]{JotPrimitiveClass.byteType, JotPrimitiveClass.byteType});
            if (jmethod != null && jmethod.getReturnType().getName().equals("void") && Modifier.isPublic(jmethod.getModifiers()) && Modifier.isStatic(jmethod.getModifiers())) {
                tools.put(jclasses[index].getName(), this.suggestCategory(jmethod.getStatements()));
            }
            ++index;
        }
        jpackages.release(jfile);
    }

    protected void scanNodesForTools(JBProject project, Node[] nodes, Map tools) {
        int index = 0;
        while (index < nodes.length) {
            if (nodes[index] instanceof JavaFileNode) {
                this.scanFileForTools(project, (JavaFileNode)nodes[index], tools);
            }
            if (nodes[index] instanceof PackageNode && nodes[index].getParent() == project) {
                this.scanNodesForTools(project, ((PackageNode)nodes[index]).getDisplayChildren(), tools);
            }
            ++index;
        }
    }

    protected Map scanProjectForTools(JBProject project) {
        TreeMap tools = new TreeMap();
        this.scanNodesForTools(project, project.getChildren(), tools);
        return tools;
    }

    protected Integer suggestCategory(JotStatement[] jstatements) {
        int index = 0;
        while (index < jstatements.length) {
            Integer result;
            JotExpression jexpr;
            if (jstatements[index] instanceof JotExpressionStatement && (jexpr = ((JotExpressionStatement)jstatements[index]).getExpression()).getMethodCall() != null) {
                String methodName = jexpr.getMethodCall().getFullName();
                if (methodName.indexOf("ArchiveWizard.registerArchiver") > -1) {
                    return _archiverIndex;
                }
                if (methodName.indexOf("Browser.addStaticBrowserListener") > -1) {
                    return _uiIndex;
                }
                if (methodName.indexOf("Browser.registerNodeViewerFactory") > -1) {
                    return _uiIndex;
                }
                if (methodName.indexOf("BuilderManager.registerBuilder") > -1) {
                    return _buildIndex;
                }
                if (methodName.indexOf("DesignerManager.registerDesigner") > -1) {
                    return _designerIndex;
                }
                if (methodName.indexOf("EditorManager.registerContextActionProvider") > -1) {
                    return _editorIndex;
                }
                if (methodName.indexOf("EditorManager.registerEditorKit") > -1) {
                    return _editorIndex;
                }
                if (methodName.indexOf("JavadocWizard.registerDoclet") > -1) {
                    return _docletIndex;
                }
                if (methodName.indexOf("JBuilderMenu.") > -1 && methodName.endsWith("add")) {
                    return _uiIndex;
                }
                if (methodName.indexOf("PrimeTime.registerCommand") > -1) {
                    return _coreIndex;
                }
                if (methodName.indexOf("PropertyManager.registerPropertyGroup") > -1) {
                    return _uiIndex;
                }
                if (methodName.indexOf("registerFileNodeClass") > -1) {
                    return _nodeIndex;
                }
                if (methodName.indexOf("RuntimeManager.registerRunner") > -1) {
                    return _uiIndex;
                }
                if (methodName.indexOf("ServerManager.registerServer") > -1) {
                    return _serversIndex;
                }
                if (methodName.indexOf("TestRunner.registerTestRunner") > -1) {
                    return _testIndex;
                }
                if (methodName.indexOf("UIDesigner.registerAssistant") > -1) {
                    return _designerIndex;
                }
                if (methodName.indexOf("Url.registerFilesystem") > -1) {
                    return _vfsIndex;
                }
                if (methodName.indexOf("UrlExplorerPage.registerUrlExplorerCustomizer") > -1) {
                    return _urlChooserIndex;
                }
                if (methodName.indexOf("WizardManager.registerWizardAction") > -1) {
                    return _wizardIndex;
                }
            }
            if ((result = this.suggestCategory(jstatements[index].getStatements())) != null) {
                return result;
            }
            ++index;
        }
        return null;
    }

    public void wizardCompleted() {
        this._tools.clear();
        this._tools = null;
    }
}

