/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.otnode;

import com.borland.primetime.node.FileType;
import com.borland.primetime.node.Project;
import com.borland.primetime.util.VetoException;
import com.borland.primetime.wizard.BasicWizardPage;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class OTProjectWizardPage1
extends BasicWizardPage {
    private JButton _browseButton;
    private JTextField _directoryText;
    private GridBagLayout _gridBagLayout = new GridBagLayout();
    private JCheckBox _helpCheck;
    private JLabel _jLabel1 = new JLabel();
    private JLabel _jLabel2;
    private JLabel _jLabel3;
    private JTextField _nameText;
    private JComboBox _typeCombo;

    public OTProjectWizardPage1(Project project) {
        this._directoryText = new JTextField();
        this._jLabel2 = new JLabel();
        this._nameText = new JTextField();
        this._browseButton = new JButton();
        this._jLabel3 = new JLabel();
        this._typeCombo = new JComboBox();
        this._helpCheck = new JCheckBox();
        try {
            this.jbInit();
            this.loadData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void _browseButton_actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser(new File(this._directoryText.getText()));
        chooser.setDialogTitle("Select Project Directory");
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showOpenDialog((Component)((Object)this)) == 0) {
            this._directoryText.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void checkCondition(boolean condition, String message, JComponent focus) throws VetoException {
        if (!condition) {
            focus.requestFocus();
            JOptionPane.showMessageDialog(this.wizardHost.getDialogParent(), message, "OpenTools Project Wizard", 0, null);
            throw new VetoException();
        }
    }

    public void checkPage() throws VetoException {
        this.checkCondition(this.getName().length() > 0, "A project name must be entered", this._nameText);
        this.checkCondition(this.getDirectory().length() > 0, "A directory must be entered", this._directoryText);
    }

    public String getDirectory() {
        return this._directoryText.getText();
    }

    public String getName() {
        return this._nameText.getText();
    }

    public String getType() {
        return (String)this._typeCombo.getSelectedItem();
    }

    public boolean isHelpIncluded() {
        return this._helpCheck.isSelected();
    }

    protected void jbInit() throws Exception {
        this.setPageTitle("Project Settings");
        this.setLayout(this._gridBagLayout);
        try {
            this.setLargeIcon(new ImageIcon(ClassLoader.getSystemResource("com/borland/jbuilder/wizard/unittest/images/JdbcLarge.gif")));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setInstructions("OpenTools allow you to extend the functionality of JBuilder.\n\nSelect a name for your project and the path to the directory where it is to be saved.");
        this._jLabel2.setDisplayedMnemonic('A');
        this._jLabel2.setLabelFor(this._nameText);
        this._jLabel2.setText("Name");
        this._nameText.setToolTipText("Enter the name of the new project");
        this._jLabel3.setDisplayedMnemonic('T');
        this._jLabel3.setLabelFor(this._typeCombo);
        this._jLabel3.setText("Type");
        this._typeCombo.setMinimumSize(new Dimension(61, 21));
        this._typeCombo.setPreferredSize(new Dimension(61, 21));
        this._jLabel1.setDisplayedMnemonic('D');
        this._jLabel1.setLabelFor(this._directoryText);
        this._jLabel1.setText("Directory");
        this._directoryText.setToolTipText("Enter the location of the new project");
        this._browseButton.setMinimumSize(new Dimension(21, 21));
        this._browseButton.setPreferredSize(new Dimension(21, 21));
        this._browseButton.setMargin(new Insets(2, 2, 2, 2));
        this._browseButton.setText("...");
        this._browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OTProjectWizardPage1.this._browseButton_actionPerformed(e);
            }
        });
        this._helpCheck.setMinimumSize(new Dimension(93, 21));
        this._helpCheck.setPreferredSize(new Dimension(93, 21));
        this._helpCheck.setMnemonic('H');
        this._helpCheck.setText("Include OpenTool help");
        ((Container)((Object)this)).add(this._jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        ((Container)((Object)this)).add(this._nameText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        ((Container)((Object)this)).add(this._jLabel3, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        ((Container)((Object)this)).add(this._typeCombo, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        ((Container)((Object)this)).add(this._jLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        ((Container)((Object)this)).add(this._directoryText, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 23), 0, 0));
        ((Container)((Object)this)).add(this._browseButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(2, 2, 2, 2), 0, 0));
        ((Container)((Object)this)).add(this._helpCheck, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
    }

    private void loadData() {
        Iterator fileTypes = FileType.getFileTypes().keySet().iterator();
        while (fileTypes.hasNext()) {
            String extension = (String)fileTypes.next();
            if (!Project.isProjectExtension((String)extension)) continue;
            this._typeCombo.addItem(extension);
        }
    }
}

