/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.otnode;

import com.borland.primetime.actions.ActionGroup;
import com.borland.primetime.node.TextStructure;
import com.borland.primetime.ui.MergeTreeNode;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import wood.keith.opentools.otnode.OTFileNode;
import wood.keith.opentools.otnode.OTMenuGroup;
import wood.keith.opentools.otnode.OTPopupMenu;
import wood.keith.opentools.otnode.OTScanner;

public class OTStructure
extends TextStructure {
    private ArrayList categories = new ArrayList(OTScanner.KEYWORDS.length);
    static /* synthetic */ Class class$wood$keith$opentools$otnode$OTStructure;
    private JPopupMenu popup = null;

    public OTStructure() {
        OTStructureNodeUserObject uo = new OTStructureNodeUserObject(0, 0, "");
        this.treeModel.setRoot((TreeNode)((Object)new OTStructureNode(uo)));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public boolean contains(String category) {
        return this.categories.contains(category);
    }

    public JPopupMenu getPopup() {
        if (this.popup == null) {
            this.popup = new OTPopupMenu(this);
        }
        return this.popup;
    }

    public ActionGroup getPopupActionGroup() {
        OTPopupMenu cfr_ignored_0 = (OTPopupMenu)((Object)this.getPopup());
        OTMenuGroup actions = OTPopupMenu.menuGroup;
        actions.updateActions(this);
        return actions;
    }

    public Color getStructureForegroundColor(Object value, Color baseFGColor, Color baseBGColor) {
        String category = value.toString();
        if (category.startsWith("OpenTools-")) {
            int index = 0;
            while (index < OTScanner.KEYWORDS.length) {
                if (category.endsWith(OTScanner.KEYWORDS[index])) {
                    return baseFGColor;
                }
                ++index;
            }
        }
        return baseFGColor.equals(Color.black) ? Color.blue : Color.black;
    }

    public Icon getStructureIcon(Object value) {
        if (!(value instanceof OTStructureNode)) {
            return null;
        }
        OTStructureNode structureNode = (OTStructureNode)((Object)value);
        switch (structureNode.getType()) {
            case 0: {
                return OTFileNode.ICON;
            }
        }
        return null;
    }

    private void nodeAction(DefaultMutableTreeNode node, boolean focus) {
        if (!(node instanceof OTStructureNode)) {
            return;
        }
        OTStructureNodeUserObject uo = (OTStructureNodeUserObject)node.getUserObject();
        if (uo.lineNo >= 0) {
            this.setCaretPosition(uo.lineNo, uo.column, focus);
        }
    }

    public void nodeActivated(DefaultMutableTreeNode node) {
        this.nodeAction(node, true);
    }

    public void nodeSelected(DefaultMutableTreeNode node) {
        this.nodeAction(node, false);
    }

    public void updateStructure(Document doc) {
        doc.putProperty(class$wood$keith$opentools$otnode$OTStructure == null ? (class$wood$keith$opentools$otnode$OTStructure = OTStructure.class$("wood.keith.opentools.otnode.OTStructure")) : class$wood$keith$opentools$otnode$OTStructure, (Object)this);
        this.categories.clear();
        final OTStructureNode newRoot = new OTStructureNode(new OTStructureNodeUserObject(0, 0, "root"));
        try {
            int lineNo = 1;
            String text = new String(this.fileNode.getBuffer().getContent());
            StringTokenizer st = new StringTokenizer(text, "\n", true);
            while (st.hasMoreTokens()) {
                int pos;
                String line = (String)st.nextElement();
                if (line.equals("\n")) {
                    ++lineNo;
                    continue;
                }
                if (line.charAt(0) == ' ' || (pos = line.indexOf(58)) <= -1) continue;
                String name = line.substring(0, pos);
                ((DefaultMutableTreeNode)((Object)newRoot)).add((MutableTreeNode)((Object)new OTStructureNode(new OTStructureNodeUserObject(lineNo, pos + 2, name))));
                this.categories.add(name);
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        Runnable update = new Runnable(){

            public void run() {
                OTStructureNode root = (OTStructureNode)((Object)OTStructure.this.treeModel.getRoot());
                ((DefaultMutableTreeNode)((Object)root)).removeAllChildren();
                root.mergeChildren(newRoot);
                root.sortChildren();
                OTStructure.this.treeModel.nodeStructureChanged((TreeNode)((Object)root));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            update.run();
        } else {
            SwingUtilities.invokeLater(update);
        }
    }

    protected class OTStructureNode
    extends MergeTreeNode {
        public static final int CATEGORY = 0;
        private int type;

        public OTStructureNode(Object userObject, int type) {
            super(userObject);
            this.type = type;
        }

        public OTStructureNode(Object userObject) {
            this(userObject, 0);
        }

        public int getType() {
            return this.type;
        }

        public void setType(int value) {
            this.type = value;
        }

        public void sortChildren() {
            MergeTreeNode[] array = this.getChildrenArray();
            if (array == null) {
                return;
            }
            Arrays.sort(array, new Comparator(this){
                private final /* synthetic */ OTStructureNode this$1;
                {
                    this.this$1 = this$1;
                }

                public int compare(Object o1, Object o2) {
                    return o1.toString().compareToIgnoreCase(o2.toString());
                }
            });
            ((DefaultMutableTreeNode)((Object)this)).children = new Vector<MergeTreeNode>(Arrays.asList(array));
        }
    }

    protected class OTStructureNodeUserObject {
        public int column;
        public int lineNo;
        public String name;

        public OTStructureNodeUserObject(int lineNo, int column, String name) {
            this.column = column;
            this.lineNo = lineNo;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

