/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.otnode;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import wood.keith.opentools.otnode.CategoryCellRenderer;
import wood.keith.opentools.otnode.CategoryEditor;
import wood.keith.opentools.otnode.ClassCellRenderer;
import wood.keith.opentools.otnode.OTScanner;

class ToolsTableModel
extends AbstractTableModel {
    private static final JComboBox CATEGORY_EDITOR;
    private static final CategoryCellRenderer CATEGORY_RENDERER;
    private static final Class[] COLUMN_CLASSES;
    private static final String[] COLUMN_NAMES;
    private static final String EXCLUDE = "<exclude>";
    private ArrayList _data = new ArrayList();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    static {
        COLUMN_NAMES = new String[]{"Class", "Category"};
        COLUMN_CLASSES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ToolsTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = ToolsTableModel.class$("java.lang.Object")) : class$java$lang$Object};
        CATEGORY_EDITOR = new JComboBox();
        CATEGORY_RENDERER = new CategoryCellRenderer();
        CATEGORY_EDITOR.addItem(EXCLUDE);
        int index = 0;
        while (index < OTScanner.KEYWORDS.length) {
            CATEGORY_EDITOR.addItem(new Integer(index));
            ++index;
        }
        CATEGORY_EDITOR.setRenderer(CATEGORY_RENDERER);
        CATEGORY_EDITOR.setEditor(new CategoryEditor());
        CATEGORY_EDITOR.setEditable(true);
    }

    ToolsTableModel() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public Class getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public int getRowCount() {
        return this._data.size();
    }

    public Map getTools() {
        TreeMap<Object, String> tools = new TreeMap<Object, String>();
        int index = 0;
        while (index < this._data.size()) {
            Object[] values = (Object[])this._data.get(index);
            if (!values[1].equals(EXCLUDE)) {
                String category = values[1] instanceof Integer ? OTScanner.KEYWORDS[(Integer)values[1]] : (String)values[1];
                tools.put(values[0], "OpenTools-" + category);
            }
            ++index;
        }
        return tools;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object[] values = (Object[])this._data.get(rowIndex);
        switch (columnIndex) {
            case 0: 
            case 1: {
                return values[columnIndex];
            }
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    public void setTableLayout(JTable table) {
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setCellRenderer(new ClassCellRenderer());
        column.setPreferredWidth(300);
        column = table.getColumnModel().getColumn(1);
        column.setCellRenderer(CATEGORY_RENDERER);
        column.setCellEditor(new DefaultCellEditor(CATEGORY_EDITOR));
        column.setPreferredWidth(100);
    }

    public void setTools(Map tools) {
        this._data.clear();
        Iterator iter = tools.keySet().iterator();
        while (iter.hasNext()) {
            Object[] values;
            values = new Object[]{iter.next(), tools.get(values[0])};
            if (values[1] == null) {
                values[1] = EXCLUDE;
            }
            this._data.add(values);
        }
        this.fireTableDataChanged();
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Object[] values = (Object[])this._data.get(rowIndex);
        switch (columnIndex) {
            case 1: {
                values[columnIndex] = aValue;
            }
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }
}

