package wood.keith.opentools.otnode;

import com.borland.primetime.PrimeTime;
import com.borland.primetime.editor.EditorManager;
import com.borland.primetime.editor.Scanner;
import com.borland.primetime.editor.TextEditorKit;

/**
 * This class registers the OpenTools-specific TextEditorKit which defines
 * where to find the text scanner that understands that syntax.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  12 September 2001
 * @version  1.1  19 February 2002
 */
public class OTEditorKit extends TextEditorKit {

	/**
	 * Register the TextEditorKit for OpenTools files.
	 *
	 * Provides the needed OpenTools interface required to register the
	 * TextEditorKit which knows the internals of this file type.
	 *
	 * @param  majorVersion  the major version of the current OpenTools API
	 * @param  minorVersion  the minor version of the current OpenTools API
	 */
	public static void initOpenTool(byte majorVersion, byte minorVersion) {
		if (majorVersion != PrimeTime.CURRENT_MAJOR_VERSION) {
			return;
		}
		EditorManager.registerEditorKit(new OTEditorKit());
	}

	/**
	 * Create an instance of the appropriate Scanner class to use with this kit.
	 *
	 * @return  a Scanner instance appropriate for documents of this class
	 */
	public Scanner createScanner() {
		return new OTScanner();
	}

	/**
	 * Get the MIME type of the data that this kit provides support for.
	 *
	 * @return  MIME type supported
	 */
	public String getContentType() {
		return "text/plain";
	}

	/**
	 * Create a copy of the editor kit. This allows an implementation to
	 * serve as a prototype for others, so that they can be quickly created.
	 *
	 * @return  new instance of the editor kit
	 */
	public Object clone() {
		return new OTEditorKit();
	}
}