package wood.keith.opentools.otnode;

import javax.swing.Icon;
import javax.swing.ImageIcon;

import com.borland.primetime.PrimeTime;
import com.borland.primetime.node.DuplicateNodeException;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.Project;
import com.borland.primetime.node.TextFileNode;
import com.borland.primetime.vfs.Url;

/**
 * This class registers the .opentools file extension.  It defines where to
 * find the TextEditorKit class that understands its syntax and the class that
 * can produce the Structure Pane content.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  12 September 2001
 * @version  1.1  19 February 2002
 * @version  2.0  20 May 2003
 * @version  2.1  10 December 2003
 */
public class OTFileNode extends TextFileNode {

  public static Icon ICON = new ImageIcon(ClassLoader.getSystemResource(
      OTFileNode.class.getName().replace('.', '/') + ".gif"));

  private static final String VERSION = "2.1";

  /**
   * Register the new file type.
   * Provides the needed OpenTools interface required to register the
   * FileNode we are defining.
   *
   * @param  majorVersion  the major version of the current OpenTools API
   * @param  minorVersion  the minor version of the current OpenTools API
   */
  public static void initOpenTool(byte majorVersion, byte minorVersion) {
    if (majorVersion != PrimeTime.CURRENT_MAJOR_VERSION) {
      return;
    }
    registerFileNodeClass("opentools", "OpenTools manifest file",
      OTFileNode.class, ICON);
    if (PrimeTime.isVerbose()) {
      System.out.println("Loaded OpenTools file node v" + VERSION);
      System.out.println("Written by Keith Wood (kbwood@iprimus.com.au)");
    }
  }

  /**
   * All FileNode subtypes must expose this constructor signature.
   *
   * @param  project  the Project to which this file node belongs
   * @param  parent   the file node parent
   * @param  url      the location of the file
   */
  public OTFileNode(Project project, Node parent, Url url)
      throws DuplicateNodeException {
    super(project, parent, url);
  }

  /**
   * Provide alternative icon.
   *
   * @return  the icon for file type
   */
  public Icon getDisplayIcon() { return ICON; }

  /**
   * Provide alternative TextEditorKit.
   *
   * @return  the TextEditorKit class for file type
   */
  public Class getEditorKitClass() { return OTEditorKit.class; }

  /**
   * Provide alternative provider for Structure Pane content.
   *
   * @return  the TextStructure class for file type
   */
  public Class getTextStructureClass() { return OTStructure.class; }
}
