package wood.keith.opentools.otnode;

import com.borland.jbuilder.personality.JBuilderPersonality;
import com.borland.primetime.PrimeTime;
import com.borland.primetime.personality.DefaultPersonality;
import com.borland.primetime.personality.Personality;
import com.borland.primetime.personality.PersonalityManager;

/**
 * A personality for OpenTools.
*
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  22 December 2003
 */
public class OTPersonality extends DefaultPersonality {

  /** This personality as a list. */
  public static final Personality[] PERSONALITIES =
      new Personality[] {new OTPersonality()};
  /** The list of dependency personality class names. */
  private static final String[] DEPENDENCIES =
      new String[] {JBuilderPersonality.class.getName()};
  /** OpenTools version for JBuilder 10. */
  private static final byte JB10_VERSION = 7;

  /**
   * Register the "OpenTools Personality" tool.
   *
   * @param  majorVersion  the major version of the current OpenTools API
   * @param  minorVersion  the minor version of the current OpenTools API
   */
  public static void initOpenTool(byte majorVersion, byte minorVersion) {
    if (majorVersion != PrimeTime.CURRENT_MAJOR_VERSION ||
        minorVersion < JB10_VERSION) {
      return;
    }
    PersonalityManager.registerPersonality(PERSONALITIES[0]);
  }

  /**
   * Create the personality and give it a description.
   */
  public OTPersonality() {
    super("OpenTools");
  }

  /**
   * List the other personalities that this one depends upon.
   *
   * @return  the list of dependency personality class names
   */
  public String[] getDepend() { return DEPENDENCIES; }
}
