package wood.keith.opentools.otnode;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

import com.borland.jbuilder.node.JBProject;
import com.borland.primetime.node.FileType;
import com.borland.primetime.node.Project;
import com.borland.primetime.util.VetoException;
import com.borland.primetime.wizard.BasicWizardPage;

/**
 * This class contains wizard page 1 of the OpenTools Project Wizard.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  19 May 2003
 */
public class OTProjectWizardPage1 extends BasicWizardPage {

	private GridBagLayout _gridBagLayout = new GridBagLayout();
	private JLabel _jLabel1 = new JLabel();
	private JTextField _directoryText = new JTextField();
	private JLabel _jLabel2 = new JLabel();
	private JTextField _nameText = new JTextField();
	private JButton _browseButton = new JButton();
	private JLabel _jLabel3 = new JLabel();
	private JComboBox _typeCombo = new JComboBox();
	private JCheckBox _helpCheck = new JCheckBox();

	/**
	 * Create a new wizard page.
	 *
	 * @param  project  the current project
	 */
	public OTProjectWizardPage1(Project project) {
		try {
			jbInit();
			loadData();
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Define the user interface.
	 * The user interface is constructed here so the JBuilder UI Designer
	 * may be used to edit it.
	 */
	protected void jbInit() throws Exception {
		this.setPageTitle("Project Settings");
		this.setLayout(_gridBagLayout);
		try {
			this.setLargeIcon(new ImageIcon(ClassLoader.getSystemResource(
				"com/borland/jbuilder/wizard/unittest/images/JdbcLarge.gif")));
		}
		catch(Exception e) {
			// Ignore
		}
		this.setInstructions("OpenTools allow you to extend the functionality of JBuilder.\n\n" +
		"Select a name for your project and the path to the directory where it is to be saved.");
		_jLabel2.setDisplayedMnemonic('A');
		_jLabel2.setLabelFor(_nameText);
		_jLabel2.setText("Name");
		_nameText.setToolTipText("Enter the name of the new project");
		_jLabel3.setDisplayedMnemonic('T');
		_jLabel3.setLabelFor(_typeCombo);
		_jLabel3.setText("Type");
		_typeCombo.setMinimumSize(new Dimension(61, 21));
		_typeCombo.setPreferredSize(new Dimension(61, 21));
		_jLabel1.setDisplayedMnemonic('D');
		_jLabel1.setLabelFor(_directoryText);
		_jLabel1.setText("Directory");
		_directoryText.setToolTipText("Enter the location of the new project");
		_browseButton.setMinimumSize(new Dimension(21, 21));
		_browseButton.setPreferredSize(new Dimension(21, 21));
		_browseButton.setMargin(new Insets(2, 2, 2, 2));
		_browseButton.setText("...");
		_browseButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_browseButton_actionPerformed(e);
			}
		});
		_helpCheck.setMinimumSize(new Dimension(93, 21));
		_helpCheck.setPreferredSize(new Dimension(93, 21));
		_helpCheck.setMnemonic('H');
		_helpCheck.setText("Include OpenTool help");
		this.add(_jLabel2,  new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
						,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
		this.add(_nameText,   new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
						,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 2, 2, 2), 0, 0));
		this.add(_jLabel3,   new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
						,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
		this.add(_typeCombo,      new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
						,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
		this.add(_jLabel1,   new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
						,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
		this.add(_directoryText,       new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0
						,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 2, 2, 23), 0, 0));
		this.add(_browseButton,       new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0
						,GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
		this.add(_helpCheck,     new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0
						,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(2, 2, 2, 2), 0, 0));
	}

	/**
	 * Initialise UI controls.
	 */
	private void loadData() {
		Iterator fileTypes = FileType.getFileTypes().keySet().iterator();
		while (fileTypes.hasNext()) {
			String extension = (String)fileTypes.next();
			if (JBProject.isProjectExtension(extension)) {
				_typeCombo.addItem(extension);
			}
		}
	}

	/**
	 * Browse for a directory to use.
	 *
	 * @param  e  the triggering event
	 */
	void _browseButton_actionPerformed(ActionEvent e) {
		JFileChooser chooser = new JFileChooser(new File(_directoryText.getText()));
		chooser.setDialogTitle("Select Project Directory");
		chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		chooser.setMultiSelectionEnabled(false);
		if (chooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
			_directoryText.setText(chooser.getSelectedFile().getAbsolutePath());
		}
	}

	/**
	 * Check for user input error.
	 * The user has completed this page so check for input error.
	 * If any, then report the error in a dialog and throw an exception.
	 */
	public void checkPage() throws VetoException {
		checkCondition(getName().length() > 0,
			"A project name must be entered", _nameText);
		checkCondition(getDirectory().length() > 0,
			"A directory must be entered", _directoryText);
	}

	/**
	 * Check for a user input error.
	 *
	 * @param  condition  a test that must be true for the page to be valid
	 * @param  message    the text to display
	 * @param  focus      the UI component to move focus to
	 * @throws  VetoException  if the condition is not met
	 */
	private void checkCondition(boolean condition, String message,
			JComponent focus) throws VetoException {
		if (!condition) {
			focus.requestFocus();
			JOptionPane.showMessageDialog(wizardHost.getDialogParent(), message,
				OTProjectWizard.TITLE, JOptionPane.ERROR_MESSAGE, null);
			throw new VetoException();
		}
	}

	/**
	 * Fetches the name for the new project.
	 *
	 * @return  the project name
	 */
	public String getName() { return _nameText.getText(); }

	/**
	 * Fetches the type for the new project.
	 *
	 * @return  the project type
	 */
	public String getType() { return (String)_typeCombo.getSelectedItem(); }

	/**
	 * Fetches the directory for the new project.
	 *
	 * @return  the directory
	 */
	public String getDirectory() { return _directoryText.getText(); }

	/**
	 * Add support for including help for the new project.
	 *
	 * @return  true to include help, false if not
	 */
	public boolean isHelpIncluded() { return _helpCheck.isSelected(); }
}