/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.sampler;

import com.borland.jbuilder.JBuilderMenu;
import com.borland.jbuilder.ide.PackageBrowserTree;
import com.borland.jbuilder.info.JBuilderInfo;
import com.borland.jbuilder.node.JBProject;
import com.borland.primetime.PrimeTime;
import com.borland.primetime.actions.UpdateAction;
import com.borland.primetime.help.HelpTopic;
import com.borland.primetime.help.PrimetimeHelp;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ui.ButtonStrip;
import com.borland.primetime.ui.CheckTree;
import com.borland.primetime.ui.CheckTreeModel;
import com.borland.primetime.ui.CheckTreeNode;
import com.borland.primetime.ui.ClipPathRenderer;
import com.borland.primetime.ui.ColorCombo;
import com.borland.primetime.ui.ColorPanel;
import com.borland.primetime.ui.CompositeIcon;
import com.borland.primetime.ui.DefaultDialog;
import com.borland.primetime.ui.DialogValidator;
import com.borland.primetime.ui.EdgeBorder;
import com.borland.primetime.ui.KeyStrokeDialog;
import com.borland.primetime.ui.KeyStrokeEditorPanel;
import com.borland.primetime.ui.LowBorder;
import com.borland.primetime.ui.MessageLabel;
import com.borland.primetime.ui.TexturePanel;
import com.borland.primetime.ui.table.TableSorter;
import com.borland.primetime.util.AuraImage;
import com.borland.primetime.util.Icons;
import com.borland.primetime.util.Images;
import com.borland.primetime.util.Platform;
import com.borland.primetime.util.Strings;
import com.borland.primetime.util.ZipIndex;
import com.borland.primetime.util.ZipIndexEntry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import wood.keith.opentools.sampler.ListPanelSample;

public class UISampler
extends JPanel
implements DocumentListener {
    private static final UpdateAction ACTION_UISampler = new UpdateAction("UI Sampler", '\u0000', "Examples of JBuilder's UI components and utility classes"){

        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = new Frame("JBuilder UI Sampler");
            frame.add(new UISampler());
            frame.addWindowListener(new WindowAdapter(this, frame){
                private final /* synthetic */ 1 this$0;
                private final /* synthetic */ Frame val$frame;
                {
                    this.this$0 = this$0;
                    this.val$frame = val$frame;
                }

                public void windowClosing(WindowEvent e) {
                    this.val$frame.dispose();
                }
            });
            ((Component)frame).setBounds(100, 100, 600, 400);
            frame.pack();
            frame.show();
        }
    };
    private static final byte JB10_VERSION = 7;
    private static final String VERSION = "1.1";
    private static byte _minorVersion;
    private AuraImage aura;
    private JLabel auraLabel;
    private BorderLayout borderLayout;
    private BorderLayout borderLayout1;
    private JCheckBox bottomCheckBox;
    private ButtonStrip buttonStrip;
    private JComboBox clipCombo;
    private ColorCombo colorCombo;
    private ColorPanel colorPanel;
    private GridBagLayout colourGridBag;
    private JPanel colourTab;
    private JTextField companyField;
    private static final String[] data;
    private JTextField descriptionField;
    private JLabel disabledLabel;
    private ActionListener edgeListener;
    private JTextField encodingField;
    private GridBagLayout encodingGridBag;
    private JPanel encodingPanel;
    private JCheckBox entCheckBox;
    private Border etchedBorder;
    private JLabel icon1Label;
    private JLabel icon2Label;
    private JLabel icon3Label;
    private Image image;
    private GridBagLayout infoGridBag;
    private JPanel infoTab;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    JLabel jLabel20;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JButton keystrokeButton;
    private GridBagLayout keystrokeGridBag;
    private KeyStrokeEditorPanel keystrokePanel;
    private JPanel keystrokeTab;
    private JCheckBox leftCheckBox;
    private JCheckBox licensedCheckBox;
    private Border lineBorder;
    private JCheckBox linuxCheckBox;
    private GridBagLayout listGridBag;
    private ListPanelSample listPanel;
    private JPanel listTab;
    private LowBorder lowBorder = new LowBorder();
    private JTabbedPane mainTabs;
    private JScrollPane manifestScroll;
    private JTextArea manifestText;
    private MessageLabel messageLabel;
    private GridBagLayout miscGridBag;
    private JPanel miscTab;
    private JButton modalDialogButton;
    private JTextField numberField;
    private JTextField osField;
    private JCheckBox proCheckBox;
    private JButton resultButton;
    private JTextField resultField;
    private JCheckBox rightCheckBox;
    private JCheckBox selectTopCheckBox;
    private JButton simpleDialogButton;
    JTextField skuField;
    private JCheckBox solarisCheckBox;
    private TableSorter sorterModel;
    private JScrollPane sorterScroll;
    private JTable sorterTable;
    private static final Object[] tableColumns;
    private static final Object[][] tableData;
    private JPanel tableTab;
    private TexturePanel texturePanel;
    private TitledBorder titledBorder;
    private JCheckBox topCheckBox;
    private JCheckBox trialCheckBox;
    private JCheckBox unixCheckBox;
    private JTextField userField;
    private JButton validateDialogButton;
    private JTextField valueField;
    private JCheckBox winCheckBox;
    private JButton zipBrowseButton;
    private GridBagLayout zipGridBag;
    private JLabel zipLabel;
    private JScrollPane zipScroll;
    private JPanel zipTab;
    private CheckTree zipTree;

    static {
        data = new String[]{"c:/JBuilder/myprojects/wood/keith/opentools/sampler/Sampler.java", "c:/JBuilder/myprojects/wood/keith/opentools/sampler/Sampler.html", "c:/JBuilder/myprojects/wood/keith/opentools/sampler/Sampler.jpx", "c:/JBuilder/myprojects/wood/keith/opentools/sampler/Sampler.jpx.local", "c:/JBuilder/myprojects/wood/keith/opentools/sampler/Sampler.gif"};
        tableColumns = new Object[]{"Number", "Name"};
        tableData = new Object[][]{{new Integer(0), "zero"}, {new Integer(1), "one"}, {new Integer(2), "two"}, {new Integer(3), "three"}, {new Integer(4), "four"}, {new Integer(5), "five"}, {new Integer(6), "six"}, {new Integer(7), "seven"}, {new Integer(8), "eight"}, {new Integer(9), "nine"}, {new Integer(0), "zero"}, {new Integer(1), "un"}, {new Integer(2), "deux"}, {new Integer(3), "trois"}, {new Integer(4), "quatre"}, {new Integer(5), "cinq"}, {new Integer(6), "six"}, {new Integer(7), "sept"}, {new Integer(8), "huit"}, {new Integer(9), "neuf"}};
    }

    public UISampler() {
        this.image = Images.getImage((URL)ClassLoader.getSystemResource("com/borland/jbuilder/designer/menu/image/openDoc.gif"));
        this.aura = new AuraImage(this.image);
        this.borderLayout = new BorderLayout();
        this.mainTabs = new JTabbedPane();
        this.colourTab = new JPanel();
        this.colourGridBag = new GridBagLayout();
        this.colorCombo = new ColorCombo();
        this.auraLabel = new JLabel();
        this.colorPanel = new ColorPanel();
        this.keystrokeTab = new JPanel();
        this.keystrokeGridBag = new GridBagLayout();
        this.keystrokePanel = new KeyStrokeEditorPanel();
        this.keystrokeButton = new JButton();
        this.messageLabel = new MessageLabel();
        this.miscTab = new JPanel();
        this.miscGridBag = new GridBagLayout();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.topCheckBox = new JCheckBox();
        this.bottomCheckBox = new JCheckBox();
        this.leftCheckBox = new JCheckBox();
        this.rightCheckBox = new JCheckBox();
        this.edgeListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UISampler.this.edgeCheckBox_actionPerformed(e);
            }
        };
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.texturePanel = new TexturePanel(this.image);
        this.jLabel10 = new JLabel();
        this.zipTab = new JPanel();
        this.zipGridBag = new GridBagLayout();
        this.zipScroll = new JScrollPane();
        this.zipLabel = new JLabel();
        this.zipBrowseButton = new JButton();
        this.manifestScroll = new JScrollPane();
        this.manifestText = new JTextArea();
        this.jLabel11 = new JLabel();
        this.encodingPanel = new JPanel();
        this.encodingGridBag = new GridBagLayout();
        this.jLabel13 = new JLabel();
        this.encodingField = new JTextField();
        this.jLabel12 = new JLabel();
        this.valueField = new JTextField();
        this.resultField = new JTextField();
        this.resultButton = new JButton();
        this.infoTab = new JPanel();
        this.infoGridBag = new GridBagLayout();
        this.jLabel14 = new JLabel();
        this.osField = new JTextField();
        this.winCheckBox = new JCheckBox();
        this.unixCheckBox = new JCheckBox();
        this.solarisCheckBox = new JCheckBox();
        this.linuxCheckBox = new JCheckBox();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.userField = new JTextField();
        this.companyField = new JTextField();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.descriptionField = new JTextField();
        this.licensedCheckBox = new JCheckBox();
        this.trialCheckBox = new JCheckBox();
        this.proCheckBox = new JCheckBox();
        this.entCheckBox = new JCheckBox();
        this.numberField = new JTextField();
        this.zipTree = new CheckTree();
        this.jLabel8 = new JLabel();
        this.clipCombo = new JComboBox();
        this.buttonStrip = new ButtonStrip();
        this.listTab = new JPanel();
        this.listGridBag = new GridBagLayout();
        this.jLabel4 = new JLabel();
        this.listPanel = new ListPanelSample();
        this.jLabel7 = new JLabel();
        this.simpleDialogButton = new JButton();
        this.modalDialogButton = new JButton();
        this.validateDialogButton = new JButton();
        this.jLabel9 = new JLabel();
        this.icon1Label = new JLabel();
        this.icon2Label = new JLabel();
        this.icon3Label = new JLabel();
        this.jPanel1 = new JPanel();
        this.disabledLabel = new JLabel();
        this.tableTab = new JPanel();
        this.borderLayout1 = new BorderLayout();
        this.jLabel1 = new JLabel();
        this.jLabel19 = new JLabel();
        this.sorterScroll = new JScrollPane();
        this.sorterTable = new JTable();
        this.sorterModel = new TableSorter();
        this.selectTopCheckBox = new JCheckBox();
        this.jLabel20 = new JLabel();
        this.skuField = new JTextField();
        try {
            this.jbInit();
            this.fillData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addFiles(CheckTreeNode parent, ZipIndex zip, ZipIndexEntry[] entries) {
        int index = 0;
        while (index < entries.length) {
            CheckTreeNode child = new CheckTreeNode(entries[index].getName() + " (" + new Date(entries[index].getLastModified()) + ")", true, false);
            parent.add((MutableTreeNode)child);
            if (entries[index].getName().equals("MANIFEST.MF")) {
                try {
                    this.manifestText.setText(new String(zip.read(entries[index])));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            if (entries[index].isDirectory()) {
                this.addFiles(child, zip, zip.getChildren(entries[index].getDirectory() + (entries[index].getDirectory().length() > 0 ? File.separator : "") + entries[index].getName()));
            }
            ++index;
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.messageLabel.setText(this.keystrokePanel.getJavaInitializationString());
    }

    void colorCombo_actionPerformed(ActionEvent e) {
        this.setAuraColour(this.colorCombo.getSelectedColor());
    }

    void colorPanel_actionPerformed(ActionEvent e) {
        this.setAuraColour(this.colorPanel.getSelectedColor());
    }

    void descriptionField_mouseClicked(MouseEvent e) {
        JBuilderInfo.showInfoDialog();
    }

    void edgeCheckBox_actionPerformed(ActionEvent e) {
        int edges = (this.topCheckBox.isSelected() ? 1 : 0) + (this.bottomCheckBox.isSelected() ? 256 : 0) + (this.leftCheckBox.isSelected() ? 16 : 0) + (this.rightCheckBox.isSelected() ? 4096 : 0);
        this.jLabel2.setBorder((Border)new EdgeBorder(edges));
    }

    private void fillData() {
        this.setAuraColour(Color.green);
        int index = 0;
        while (index < data.length) {
            this.clipCombo.addItem(data[index]);
            ++index;
        }
        this.sorterModel.setModel((TableModel)new DefaultTableModel(tableData, tableColumns));
        this.sorterTable.setModel((TableModel)this.sorterModel);
        this.sorterModel.addMouseListenerToHeaderInTable(this.sorterTable);
        this.sorterModel.sortByColumn(1);
        JButton okButton = this.buttonStrip.createOkButton(true);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UISampler.this.okButton_actionPerformed(e);
            }
        });
        this.buttonStrip.createCancelButton(true);
        this.buttonStrip.createHelpButton(true);
    }

    public static void initOpenTool(byte majorVersion, byte minorVersion) {
        if (majorVersion != 4) {
            return;
        }
        _minorVersion = minorVersion;
        JBuilderMenu.GROUP_Tools.add((Action)ACTION_UISampler);
        String[] packs = JBuilderInfo.getExpansionPackNames();
        int index = 0;
        while (index < packs.length) {
            System.out.println("expansion pack " + index + " " + packs[index]);
            ++index;
        }
        String[] descrs = JBuilderInfo.getExtraDescriptions();
        int index2 = 0;
        while (index2 < descrs.length) {
            System.out.println("extra description " + index2 + " " + descrs[index2]);
            ++index2;
        }
        if (_minorVersion >= 7) {
            System.out.println("sku " + JBuilderInfo.getSKU());
            System.out.println("sku name " + JBuilderInfo.getSKUName((int)JBuilderInfo.getSKU()));
        }
        if (PrimeTime.isVerbose()) {
            System.out.println("Loaded UISampler v1.1");
            System.out.println("Written by Keith Wood (kbwood@iprimus.com.au)");
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.messageLabel.setText(this.keystrokePanel.getJavaInitializationString());
    }

    private void jbInit() throws Exception {
        this.titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 248), new Color(161, 151, 121)), "KeyStrokeEditorPanel");
        this.lineBorder = BorderFactory.createLineBorder(Color.black, 2);
        this.etchedBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "StringEncoding");
        this.messageLabel.setText("MessageLabel");
        this.messageLabel.setPreferredSize(new Dimension(100, 40));
        this.setLayout(this.borderLayout);
        this.colourTab.setLayout(this.colourGridBag);
        this.auraLabel.setText("AuraImage");
        this.auraLabel.setHorizontalTextPosition(10);
        this.auraLabel.setIcon(new ImageIcon(this.image));
        this.auraLabel.setIconTextGap(8);
        this.keystrokeTab.setLayout(this.keystrokeGridBag);
        this.keystrokeButton.setText("KeyStrokeDialog");
        this.keystrokeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UISampler.this.keystrokeButton_actionPerformed(e);
            }
        });
        this.miscTab.setLayout(this.miscGridBag);
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("LowBorder");
        this.jLabel3.setBorder((Border)this.lowBorder);
        this.jLabel3.setMinimumSize(new Dimension(80, 40));
        this.jLabel3.setPreferredSize(new Dimension(100, 40));
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("EdgeBorder");
        this.jLabel2.setBorder((Border)new EdgeBorder(65535));
        this.jLabel2.setMinimumSize(new Dimension(80, 40));
        this.jLabel2.setPreferredSize(new Dimension(100, 40));
        this.topCheckBox.addActionListener(this.edgeListener);
        this.bottomCheckBox.addActionListener(this.edgeListener);
        this.leftCheckBox.addActionListener(this.edgeListener);
        this.rightCheckBox.addActionListener(this.edgeListener);
        this.topCheckBox.setSelected(true);
        this.leftCheckBox.setSelected(true);
        this.rightCheckBox.setSelected(true);
        this.bottomCheckBox.setSelected(true);
        this.jLabel5.setText("ColorPanel");
        this.colorPanel.setCustomColors(new Color[]{Color.white, ColorPanel.BLUE_GREEN, ColorPanel.DARK_BLUE, ColorPanel.DARK_GREEN, ColorPanel.DARK_MAGENTA, ColorPanel.DARK_RED, ColorPanel.DARK_YELLOW, Color.pink});
        this.colorPanel.setCustomColor(16, Color.darkGray);
        this.colorPanel.setCustomColors(this.colorPanel.getCustomColors());
        this.colorPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UISampler.this.colorPanel_actionPerformed(e);
            }
        });
        this.jLabel6.setText("ColorCombo");
        this.keystrokePanel.setBorder(this.titledBorder);
        this.keystrokePanel.setTextFieldDocumentListener((DocumentListener)this);
        this.colorCombo.setCustomColors(new Color[]{Color.yellow, Color.cyan, Color.red, Color.green, Color.black, Color.blue, Color.orange, Color.pink});
        this.colorCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UISampler.this.colorCombo_actionPerformed(e);
            }
        });
        this.texturePanel.setBorder(this.lineBorder);
        this.texturePanel.setPreferredSize(new Dimension(100, 50));
        this.jLabel10.setText("TexturePanel");
        this.zipTab.setLayout(this.zipGridBag);
        this.zipLabel.setText("Zip file name");
        this.zipBrowseButton.setMargin(new Insets(2, 4, 2, 4));
        this.zipBrowseButton.setText("Browse");
        this.zipBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UISampler.this.zipBrowseButton_actionPerformed(e);
            }
        });
        this.jLabel11.setText("Manifest.mf contents");
        this.manifestScroll.setPreferredSize(new Dimension(200, 50));
        this.manifestText.setPreferredSize(new Dimension(200, 50));
        this.zipScroll.setPreferredSize(new Dimension(200, 50));
        this.encodingPanel.setLayout(this.encodingGridBag);
        this.encodingPanel.setBorder(this.etchedBorder);
        this.jLabel13.setDisplayedMnemonic('E');
        this.jLabel13.setLabelFor(this.entCheckBox);
        this.jLabel13.setText("Encoding");
        this.encodingField.setText("+p-m*t/d");
        this.jLabel12.setDisplayedMnemonic('U');
        this.jLabel12.setLabelFor(this.valueField);
        this.jLabel12.setText("Value");
        this.valueField.setText("1 + 2 * 3 - 4");
        this.resultButton.setMnemonic('R');
        this.resultButton.setText("Result");
        this.resultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UISampler.this.resultButton_actionPerformed(e);
            }
        });
        this.resultField.setEditable(false);
        this.infoTab.setLayout(this.infoGridBag);
        this.jLabel14.setText("OS Name");
        this.osField.setEditable(false);
        this.osField.setText(Platform.OS_NAME);
        this.winCheckBox.setText("Windows");
        this.winCheckBox.setSelected(Platform.WIN32);
        this.unixCheckBox.setText("Unix");
        this.unixCheckBox.setHorizontalTextPosition(10);
        this.unixCheckBox.setSelected(Platform.UNIX);
        this.solarisCheckBox.setText("Solaris");
        this.solarisCheckBox.setSelected(Platform.SOLARIS);
        this.linuxCheckBox.setText("Linux");
        this.linuxCheckBox.setHorizontalTextPosition(10);
        this.linuxCheckBox.setSelected(Platform.LINUX);
        this.jLabel15.setText("User");
        this.jLabel16.setText("Company");
        this.userField.setEditable(false);
        this.userField.setText(JBuilderInfo.getUserName());
        this.companyField.setEditable(false);
        this.companyField.setText(JBuilderInfo.getCompanyName());
        this.jLabel17.setText("Description");
        this.jLabel18.setText("Build Number");
        this.descriptionField.setEditable(false);
        this.descriptionField.setText(JBuilderInfo.getDescription());
        this.descriptionField.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                UISampler.this.descriptionField_mouseClicked(e);
            }
        });
        this.numberField.setEditable(false);
        if (_minorVersion >= 7) {
            this.numberField.setText(JBuilderInfo.getBuildNumber());
        }
        this.licensedCheckBox.setText("Licensed");
        this.licensedCheckBox.setSelected(JBuilderInfo.isLicensed());
        this.trialCheckBox.setText("Trial");
        this.trialCheckBox.setHorizontalTextPosition(10);
        this.trialCheckBox.setSelected(JBuilderInfo.isTrial());
        this.proCheckBox.setText("Professional");
        this.proCheckBox.setSelected(JBuilderInfo.isGenericValueEnabled());
        this.entCheckBox.setText("Enterprise");
        this.entCheckBox.setHorizontalTextPosition(10);
        this.entCheckBox.setSelected(JBuilderInfo.isGenericPremiumEnabled());
        this.jLabel8.setDisplayedMnemonic('P');
        this.jLabel8.setLabelFor(this.proCheckBox);
        this.jLabel8.setText("ClipPathRenderer");
        this.clipCombo.setMinimumSize(new Dimension(100, 26));
        this.clipCombo.setPreferredSize(new Dimension(100, 26));
        this.clipCombo.setRenderer(new ClipPathRenderer());
        this.listTab.setLayout(this.listGridBag);
        this.jLabel4.setText("ListPanel");
        this.jLabel7.setText("DefaultDialog");
        this.simpleDialogButton.setMnemonic('S');
        this.simpleDialogButton.setText("Simple");
        this.simpleDialogButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UISampler.this.simpleDialogButton_actionPerformed(e);
            }
        });
        this.modalDialogButton.setMnemonic('M');
        this.modalDialogButton.setText("Modal");
        this.modalDialogButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UISampler.this.modalDialogButton_actionPerformed(e);
            }
        });
        this.validateDialogButton.setMnemonic('V');
        this.validateDialogButton.setText("Validate");
        this.validateDialogButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UISampler.this.validateDialogButton_actionPerformed(e);
            }
        });
        this.jLabel19.setText("ButtonStrip");
        this.jLabel9.setText("CompositeIcon");
        this.icon1Label.setText(" + ");
        this.icon1Label.setIcon(Icons.getIcon(this.getClass(), (String)"/com/borland/jbuilder/wizard/archive/ArchiveWizard.gif"));
        this.icon2Label.setText(" = ");
        this.icon2Label.setIcon(Icons.getIcon(this.getClass(), (String)"/com/borland/primetime/ide/image/error.gif"));
        this.icon3Label.setText(" ");
        this.icon3Label.setIcon((Icon)new CompositeIcon(new Icon[]{this.icon1Label.getIcon(), this.icon2Label.getIcon()}));
        this.disabledLabel.setHorizontalTextPosition(10);
        this.disabledLabel.setText("Disabled");
        this.disabledLabel.setIcon(new ImageIcon(this.image));
        this.disabledLabel.setIconTextGap(8);
        this.tableTab.setLayout(this.borderLayout1);
        this.jLabel1.setText("TableSorter");
        this.selectTopCheckBox.setText("Select top after sort");
        this.selectTopCheckBox.setMnemonic('S');
        this.selectTopCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UISampler.this.selectTopCheckBox_actionPerformed(e);
            }
        });
        this.sorterScroll.setPreferredSize(new Dimension(300, 100));
        this.jLabel20.setText("SKU");
        this.skuField.setEditable(false);
        this.skuField.setText(JBuilderInfo.getSKUDescription());
        this.add((Component)this.mainTabs, "Center");
        this.mainTabs.add((Component)this.infoTab, "Info");
        this.mainTabs.add((Component)this.colourTab, "Colour/Image");
        this.mainTabs.add((Component)this.keystrokeTab, "Keystroke");
        this.mainTabs.add((Component)this.listTab, "List");
        this.mainTabs.add((Component)this.miscTab, "Misc");
        this.mainTabs.add((Component)this.tableTab, "Table");
        this.mainTabs.add((Component)this.zipTab, "Zip/CheckTree");
        this.colourTab.add((Component)this.colorCombo, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.colourTab.add((Component)this.auraLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 0), 0, 0));
        this.colourTab.add((Component)this.colorPanel, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 4, 4), 0, 0));
        this.colourTab.add((Component)this.jLabel5, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 10, 2, new Insets(4, 4, 0, 4), 0, 0));
        this.colourTab.add((Component)this.jLabel6, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.colourTab.add((Component)this.texturePanel, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.colourTab.add((Component)this.jLabel10, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.colourTab.add((Component)this.jLabel9, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.colourTab.add((Component)this.jPanel1, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.icon1Label, null);
        this.jPanel1.add((Component)this.icon2Label, null);
        this.jPanel1.add((Component)this.icon3Label, null);
        this.colourTab.add((Component)this.disabledLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.keystrokeTab.add((Component)this.keystrokeButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.keystrokeTab.add((Component)this.keystrokePanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.zipTab.add((Component)this.zipScroll, new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.zipScroll.getViewport().add((Component)this.zipTree, null);
        this.zipTab.add((Component)this.zipLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.zipTab.add((Component)this.zipBrowseButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.zipTab.add((Component)this.manifestScroll, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.zipTab.add((Component)this.jLabel11, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 4, 0, 0), 0, 0));
        this.infoTab.add((Component)this.jLabel14, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 4, 2, 4), 0, 0));
        this.infoTab.add((Component)this.osField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 4, 2, 4), 0, 0));
        this.infoTab.add((Component)this.winCheckBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.infoTab.add((Component)this.unixCheckBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.infoTab.add((Component)this.solarisCheckBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.infoTab.add((Component)this.linuxCheckBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.infoTab.add((Component)this.jLabel15, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 4, 2, 4), 0, 0));
        this.infoTab.add((Component)this.jLabel16, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 4, 2, 4), 0, 0));
        this.infoTab.add((Component)this.userField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 4, 2, 4), 0, 0));
        this.infoTab.add((Component)this.companyField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 4, 2, 4), 0, 0));
        this.infoTab.add((Component)this.jLabel17, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 4, 2, 4), 0, 0));
        this.infoTab.add((Component)this.jLabel18, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 4, 2, 4), 0, 0));
        this.infoTab.add((Component)this.descriptionField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 4, 2, 4), 0, 0));
        this.infoTab.add((Component)this.licensedCheckBox, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.infoTab.add((Component)this.trialCheckBox, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.infoTab.add((Component)this.proCheckBox, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.infoTab.add((Component)this.entCheckBox, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.infoTab.add((Component)this.numberField, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 4, 2, 4), 0, 0));
        this.infoTab.add((Component)this.jLabel20, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 4, 2, 4), 0, 0));
        this.infoTab.add((Component)this.skuField, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 4, 2, 4), 0, 0));
        this.miscTab.add((Component)this.jLabel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 0), 0, 0));
        this.miscTab.add((Component)this.topCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 4, 0, 4), 0, 0));
        this.miscTab.add((Component)this.bottomCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 4, 0, 4), 0, 0));
        this.miscTab.add((Component)this.leftCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.miscTab.add((Component)this.rightCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 4, 4, 0), 0, 0));
        this.miscTab.add((Component)this.encodingPanel, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.encodingPanel.add((Component)this.jLabel13, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.encodingPanel.add((Component)this.encodingField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.encodingPanel.add((Component)this.jLabel12, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.encodingPanel.add((Component)this.valueField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.encodingPanel.add((Component)this.resultField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.encodingPanel.add((Component)this.resultButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.miscTab.add((Component)this.jLabel8, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.miscTab.add((Component)this.clipCombo, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 10, 2, new Insets(4, 4, 4, 100), 0, 0));
        this.miscTab.add((Component)this.jLabel3, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.miscTab.add((Component)this.jLabel19, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.miscTab.add((Component)this.buttonStrip, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.miscTab.add((Component)this.jLabel7, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.miscTab.add((Component)this.simpleDialogButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.miscTab.add((Component)this.modalDialogButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.miscTab.add((Component)this.validateDialogButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.listTab.add((Component)this.jLabel4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.listTab.add((Component)((Object)this.listPanel), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tableTab.add((Component)this.jLabel1, "North");
        this.tableTab.add((Component)this.sorterScroll, "Center");
        this.tableTab.add((Component)this.selectTopCheckBox, "South");
        this.sorterScroll.getViewport().add((Component)this.sorterTable, null);
        this.manifestScroll.getViewport().add((Component)this.manifestText, null);
        this.add((Component)this.messageLabel, "South");
    }

    void keystrokeButton_actionPerformed(ActionEvent e) {
        KeyStrokeDialog dialog = new KeyStrokeDialog((Component)this, "Select Keystroke", true);
        dialog.show();
        this.messageLabel.setText(KeyStrokeEditorPanel.getKeyStrokeText((KeyStroke)dialog.getKeyStroke()));
    }

    void modalDialogButton_actionPerformed(ActionEvent e) {
        boolean OK = DefaultDialog.showModalDialog((Component)DefaultDialog.findFrame((Component)this), (String)"Modal Dialog", (JComponent)new JButton("Your UI here"), (HelpTopic)PrimetimeHelp.TOPIC_DSelectFile);
        this.messageLabel.setText(OK ? "Dialog accepted" : "Dialog cancelled");
    }

    void okButton_actionPerformed(ActionEvent e) {
        String className = PackageBrowserTree.browseClass((JBProject)((JBProject)Browser.getActiveBrowser().getActiveProject()), (Component)this, (String)"Select a class", (String)"");
        this.messageLabel.setText(className == null || className.length() == 0 ? "Cancelled" : "Selected " + className);
    }

    public void removeUpdate(DocumentEvent e) {
        this.messageLabel.setText(this.keystrokePanel.getJavaInitializationString());
    }

    void resultButton_actionPerformed(ActionEvent e) {
        Strings.StringEncoding encoding = new Strings.StringEncoding(this.encodingField.getText());
        this.resultField.setText(encoding.encode(this.valueField.getText()));
    }

    void selectTopCheckBox_actionPerformed(ActionEvent e) {
        this.sorterModel.setSelectTopAfterSort(this.selectTopCheckBox.isSelected());
    }

    void setAuraColour(Color colour) {
        this.messageLabel.setText(colour.toString());
        this.aura.setAuraRGB(colour.getRGB());
        this.auraLabel.setIcon(new ImageIcon(this.aura.getBlendedImage()));
        this.disabledLabel.setIcon(new ImageIcon(Images.getDisabledImage((Image)this.aura.getBlendedImage())));
    }

    void simpleDialogButton_actionPerformed(ActionEvent e) {
        DefaultDialog.showSimpleModalDialog((Component)DefaultDialog.findFrame((Component)this), (String)"Simple Modal Dialog", (JComponent)new JButton("Your UI here"), null);
    }

    void validateDialogButton_actionPerformed(ActionEvent e) {
        final Frame frame = DefaultDialog.findFrame((Component)this);
        boolean OK = DefaultDialog.showModalDialog((Component)frame, (String)"Validating Modal Dialog", (JComponent)new JButton("Your UI here"), (HelpTopic)PrimetimeHelp.TOPIC_DSelectFile, (DialogValidator)new DialogValidator(){

            public boolean validateDialog() {
                return JOptionPane.showConfirmDialog(frame, "Is this valid?", "Sampler Validator", 0) == 0;
            }
        });
        this.messageLabel.setText(OK ? "Dialog accepted" : "Dialog cancelled");
    }

    void zipBrowseButton_actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser(FileSystemView.getFileSystemView());
        chooser.setDialogTitle("Open Zip File");
        chooser.setFileSelectionMode(2);
        chooser.setSelectedFile(new File(this.zipLabel.getText()));
        chooser.addChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String path = file.getPath();
                return file.isDirectory() || path.length() > 4 && path.substring(path.length() - 4).toLowerCase().equals(".jar");
            }

            public String getDescription() {
                return "JAR files";
            }
        });
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String path = file.getPath();
                return file.isDirectory() || path.length() > 4 && path.substring(path.length() - 4).toLowerCase().equals(".zip");
            }

            public String getDescription() {
                return "Zip files";
            }
        });
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        String fileName = chooser.getSelectedFile().getAbsolutePath();
        ZipIndex zip = ZipIndex.getZipIndex((File)new File(fileName));
        this.zipLabel.setText(fileName);
        CheckTreeNode root = new CheckTreeNode((Object)"root");
        this.addFiles(root, zip, zip.getChildren(""));
        this.zipTree.setModel((TreeModel)new CheckTreeModel((TreeNode)root));
        this.zipTree.invalidate();
    }
}

