package wood.keith.opentools.sampler;

import javax.swing.JOptionPane;

import com.borland.primetime.ui.ListPanel;

/**
 * Sampler showing off UI components from JBuilder.
 * A ListPanel implementation.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  26 February 2002
 */
public class ListPanelSample extends ListPanel {

  private static final String TITLE = "ListPanel Demo";

  private static final String[] DATA =
      {"One", "Two", "Three", "Four", "Five", "Six", "Seven"};

  /**
   * Fill list with data.
   */
  public ListPanelSample() {
    super("New...", 'N', "Change...", 'C', "Erase...", 'E');
    addListElement(DATA);
  }

  /**
   * Allow the user to update an item.
   */
  protected Object editElement(Object object) {
    Object newObject = JOptionPane.showInputDialog(null,
        "Edit \"" + object + "\"",
        TITLE + " Edit", JOptionPane.QUESTION_MESSAGE);
    return (newObject == null || newObject.equals("") ? object : newObject);
  }

  /**
   * Allow the user to create a new item.
   */
  protected Object promptForElement() {
    Object newObject = JOptionPane.showInputDialog(null, "New element",
        TITLE + " Add", JOptionPane.QUESTION_MESSAGE);
    return (newObject == null || newObject.equals("") ? null : newObject);
  }
}
