package wood.keith.opentools.sampler;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.DefaultTableModel;

import com.borland.jbuilder.JBuilderMenu;
import com.borland.jbuilder.ide.PackageBrowserTree;
import com.borland.jbuilder.info.JBuilderInfo;
import com.borland.jbuilder.node.JBProject;
import com.borland.primetime.PrimeTime;
import com.borland.primetime.actions.UpdateAction;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.help.PrimetimeHelp;
import com.borland.primetime.ui.ButtonStrip;
import com.borland.primetime.ui.CheckTree;
import com.borland.primetime.ui.CheckTreeModel;
import com.borland.primetime.ui.CheckTreeNode;
import com.borland.primetime.ui.ClipPathRenderer;
import com.borland.primetime.ui.ColorCombo;
import com.borland.primetime.ui.ColorPanel;
import com.borland.primetime.ui.CompositeIcon;
import com.borland.primetime.ui.DefaultDialog;
import com.borland.primetime.ui.DialogValidator;
import com.borland.primetime.ui.EdgeBorder;
import com.borland.primetime.ui.KeyStrokeDialog;
import com.borland.primetime.ui.KeyStrokeEditorPanel;
import com.borland.primetime.ui.LowBorder;
import com.borland.primetime.ui.MessageLabel;
import com.borland.primetime.ui.TexturePanel;
import com.borland.primetime.ui.table.TableSorter;
import com.borland.primetime.util.AuraImage;
import com.borland.primetime.util.Icons;
import com.borland.primetime.util.Images;
import com.borland.primetime.util.Platform;
import com.borland.primetime.util.Strings;
import com.borland.primetime.util.Strings.StringEncoding;
import com.borland.primetime.util.ZipIndex;
import com.borland.primetime.util.ZipIndexEntry;

/**
 * Sampler showing off UI components and utility classes from JBuilder.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  26 February 2002
 */
public class UISampler extends JPanel implements DocumentListener {

  private static final String VERSION = "1.1";
  private static final byte JB10_VERSION = 7;
  private static byte _minorVersion;

  private static final UpdateAction ACTION_UISampler = new UpdateAction(
      "UI Sampler", '\0',
      "Examples of JBuilder's UI components and utility classes") {
    public void actionPerformed(ActionEvent actionEvent) {
      final Frame frame = new Frame("JBuilder UI Sampler");
      frame.add(new UISampler());
      frame.addWindowListener(new WindowAdapter() {
        public void windowClosing(WindowEvent e) {
          frame.dispose();
        }
      });
      frame.setBounds(100, 100, 600, 400);
      frame.pack();
      frame.show();
    }
  };

  /**
   * Register an action to trigger the "UISampler" tool.
   *
   * @param  majorVersion  the major version of the current OpenTools API
   * @param  minorVersion  the minor version of the current OpenTools API
   */
  public static void initOpenTool(byte majorVersion, byte minorVersion) {
    if (majorVersion != PrimeTime.CURRENT_MAJOR_VERSION) {
      return;
    }
    _minorVersion = minorVersion;
    JBuilderMenu.GROUP_Tools.add(ACTION_UISampler);
    String[] packs = JBuilderInfo.getExpansionPackNames();
    for (int index = 0; index < packs.length; index++) {
      System.out.println("expansion pack " + index + " " + packs[index]);
    }
    String[] descrs = JBuilderInfo.getExtraDescriptions();
    for (int index = 0; index < descrs.length; index++) {
      System.out.println("extra description " + index + " " + descrs[index]);
    }
    if (_minorVersion >= JB10_VERSION) {
      System.out.println("sku " + JBuilderInfo.getSKU());
      System.out.println("sku name " +
          JBuilderInfo.getSKUName(JBuilderInfo.getSKU()));
    }
    if (PrimeTime.isVerbose()) {
      System.out.println("Loaded UISampler v" + VERSION);
      System.out.println("Written by Keith Wood (kbwood@iprimus.com.au)");
    }
  }

  private static final String[] data =
      {"c:/JBuilder/myprojects/wood/keith/opentools/sampler/Sampler.java",
      "c:/JBuilder/myprojects/wood/keith/opentools/sampler/Sampler.html",
      "c:/JBuilder/myprojects/wood/keith/opentools/sampler/Sampler.jpx",
      "c:/JBuilder/myprojects/wood/keith/opentools/sampler/Sampler.jpx.local",
      "c:/JBuilder/myprojects/wood/keith/opentools/sampler/Sampler.gif"};
  private static final Object[] tableColumns = {"Number", "Name"};
  private static final Object[][] tableData =
      {{new Integer(0), "zero"}, {new Integer(1), "one"},
      {new Integer(2), "two"}, {new Integer(3), "three"},
      {new Integer(4), "four"}, {new Integer(5), "five"},
      {new Integer(6), "six"}, {new Integer(7), "seven"},
      {new Integer(8), "eight"}, {new Integer(9), "nine"},
      {new Integer(0), "zero"}, {new Integer(1), "un"},
      {new Integer(2), "deux"}, {new Integer(3), "trois"},
      {new Integer(4), "quatre"}, {new Integer(5), "cinq"},
      {new Integer(6), "six"}, {new Integer(7), "sept"},
      {new Integer(8), "huit"}, {new Integer(9), "neuf"}};

  private LowBorder lowBorder = new LowBorder();
  private Image image = Images.getImage(ClassLoader.getSystemResource(
      "com/borland/jbuilder/designer/menu/image/openDoc.gif"));
  private AuraImage aura = new AuraImage(image);
  private BorderLayout borderLayout = new BorderLayout();
  private JTabbedPane mainTabs = new JTabbedPane();
  private JPanel colourTab = new JPanel();
  private GridBagLayout colourGridBag = new GridBagLayout();
  private ColorCombo colorCombo = new ColorCombo();
  private JLabel auraLabel = new JLabel();
  private ColorPanel colorPanel = new ColorPanel();
  private JPanel keystrokeTab = new JPanel();
  private GridBagLayout keystrokeGridBag = new GridBagLayout();
  private KeyStrokeEditorPanel keystrokePanel = new KeyStrokeEditorPanel();
  private JButton keystrokeButton = new JButton();
  private MessageLabel messageLabel = new MessageLabel();
  private JPanel miscTab = new JPanel();
  private GridBagLayout miscGridBag = new GridBagLayout();
  private JLabel jLabel3 = new JLabel();
  private JLabel jLabel2 = new JLabel();
  private JCheckBox topCheckBox = new JCheckBox();
  private JCheckBox bottomCheckBox = new JCheckBox();
  private JCheckBox leftCheckBox = new JCheckBox();
  private JCheckBox rightCheckBox = new JCheckBox();
  private ActionListener edgeListener = new java.awt.event.ActionListener() {
    public void actionPerformed(ActionEvent e) {
      edgeCheckBox_actionPerformed(e);
    }
  };
  private JLabel jLabel5 = new JLabel();
  private JLabel jLabel6 = new JLabel();
  private TitledBorder titledBorder;
  private TexturePanel texturePanel = new TexturePanel(image);
  private JLabel jLabel10 = new JLabel();
  private Border lineBorder;
  private JPanel zipTab = new JPanel();
  private GridBagLayout zipGridBag = new GridBagLayout();
  private JScrollPane zipScroll = new JScrollPane();
  private JLabel zipLabel = new JLabel();
  private JButton zipBrowseButton = new JButton();
  private JScrollPane manifestScroll = new JScrollPane();
  private JTextArea manifestText = new JTextArea();
  private JLabel jLabel11 = new JLabel();
  private JPanel encodingPanel = new JPanel();
  private GridBagLayout encodingGridBag = new GridBagLayout();
  private Border etchedBorder;
  private JLabel jLabel13 = new JLabel();
  private JTextField encodingField = new JTextField();
  private JLabel jLabel12 = new JLabel();
  private JTextField valueField = new JTextField();
  private JTextField resultField = new JTextField();
  private JButton resultButton = new JButton();
  private JPanel infoTab = new JPanel();
  private GridBagLayout infoGridBag = new GridBagLayout();
  private JLabel jLabel14 = new JLabel();
  private JTextField osField = new JTextField();
  private JCheckBox winCheckBox = new JCheckBox();
  private JCheckBox unixCheckBox = new JCheckBox();
  private JCheckBox solarisCheckBox = new JCheckBox();
  private JCheckBox linuxCheckBox = new JCheckBox();
  private JLabel jLabel15 = new JLabel();
  private JLabel jLabel16 = new JLabel();
  private JTextField userField = new JTextField();
  private JTextField companyField = new JTextField();
  private JLabel jLabel17 = new JLabel();
  private JLabel jLabel18 = new JLabel();
  private JTextField descriptionField = new JTextField();
  private JCheckBox licensedCheckBox = new JCheckBox();
  private JCheckBox trialCheckBox = new JCheckBox();
  private JCheckBox proCheckBox = new JCheckBox();
  private JCheckBox entCheckBox = new JCheckBox();
  private JTextField numberField = new JTextField();
  private CheckTree zipTree = new CheckTree();
  private JLabel jLabel8 = new JLabel();
  private JComboBox clipCombo = new JComboBox();
  private ButtonStrip buttonStrip = new ButtonStrip();
  private JPanel listTab = new JPanel();
  private GridBagLayout listGridBag = new GridBagLayout();
  private JLabel jLabel4 = new JLabel();
  private ListPanelSample listPanel = new ListPanelSample();
  private JLabel jLabel7 = new JLabel();
  private JButton simpleDialogButton = new JButton();
  private JButton modalDialogButton = new JButton();
  private JButton validateDialogButton = new JButton();
  private JLabel jLabel9 = new JLabel();
  private JLabel icon1Label = new JLabel();
  private JLabel icon2Label = new JLabel();
  private JLabel icon3Label = new JLabel();
  private JPanel jPanel1 = new JPanel();
  private JLabel disabledLabel = new JLabel();
  private JPanel tableTab = new JPanel();
  private BorderLayout borderLayout1 = new BorderLayout();
  private JLabel jLabel1 = new JLabel();
  private JLabel jLabel19 = new JLabel();
  private JScrollPane sorterScroll = new JScrollPane();
  private JTable sorterTable = new JTable();
  private TableSorter sorterModel = new TableSorter();
  private JCheckBox selectTopCheckBox = new JCheckBox();
  JLabel jLabel20 = new JLabel();
  JTextField skuField = new JTextField();

  public UISampler() {
    try {
      jbInit();
      fillData();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * UI initialisation.
   *
   * @throws  Exception
   */
  private void jbInit() throws Exception {
    titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 248),new Color(161, 151, 121)),"KeyStrokeEditorPanel");
    lineBorder = BorderFactory.createLineBorder(Color.black,2);
    etchedBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142)),"StringEncoding");
    messageLabel.setText("MessageLabel");
    messageLabel.setPreferredSize(new Dimension(100, 40));
    this.setLayout(borderLayout);
    colourTab.setLayout(colourGridBag);
    auraLabel.setText("AuraImage");
    auraLabel.setHorizontalTextPosition(SwingConstants.LEADING);
    auraLabel.setIcon(new ImageIcon(image));
    auraLabel.setIconTextGap(8);
    keystrokeTab.setLayout(keystrokeGridBag);
    keystrokeButton.setText("KeyStrokeDialog");
    keystrokeButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        keystrokeButton_actionPerformed(e);
      }
    });
    miscTab.setLayout(miscGridBag);
    jLabel3.setHorizontalAlignment(SwingConstants.CENTER);
    jLabel3.setText("LowBorder");
    jLabel3.setBorder(lowBorder);
    jLabel3.setMinimumSize(new Dimension(80, 40));
    jLabel3.setPreferredSize(new Dimension(100, 40));
    jLabel2.setHorizontalAlignment(SwingConstants.CENTER);
    jLabel2.setText("EdgeBorder");
    jLabel2.setBorder(new EdgeBorder(0xFFFF));
    jLabel2.setMinimumSize(new Dimension(80, 40));
    jLabel2.setPreferredSize(new Dimension(100, 40));
    topCheckBox.addActionListener(edgeListener);
    bottomCheckBox.addActionListener(edgeListener);
    leftCheckBox.addActionListener(edgeListener);
    rightCheckBox.addActionListener(edgeListener);
    topCheckBox.setSelected(true);
    leftCheckBox.setSelected(true);
    rightCheckBox.setSelected(true);
    bottomCheckBox.setSelected(true);
    jLabel5.setText("ColorPanel");
    colorPanel.setCustomColors(new Color[] {Color.white, ColorPanel.BLUE_GREEN, ColorPanel.DARK_BLUE, ColorPanel.DARK_GREEN, ColorPanel.DARK_MAGENTA, ColorPanel.DARK_RED, ColorPanel.DARK_YELLOW, Color.pink});
    colorPanel.setCustomColor(16, Color.darkGray);
    colorPanel.setCustomColors(colorPanel.getCustomColors());
    colorPanel.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        colorPanel_actionPerformed(e);
      }
    });
    jLabel6.setText("ColorCombo");
    keystrokePanel.setBorder(titledBorder);
    keystrokePanel.setTextFieldDocumentListener(this);
    colorCombo.setCustomColors(new Color[] {Color.yellow, Color.cyan, Color.red, Color.green, Color.black, Color.blue, Color.orange, Color.pink});
    colorCombo.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        colorCombo_actionPerformed(e);
      }
    });
    texturePanel.setBorder(lineBorder);
    texturePanel.setPreferredSize(new Dimension(100, 50));
    jLabel10.setText("TexturePanel");
    zipTab.setLayout(zipGridBag);
    zipLabel.setText("Zip file name");
    zipBrowseButton.setMargin(new Insets(2, 4, 2, 4));
    zipBrowseButton.setText("Browse");
    zipBrowseButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        zipBrowseButton_actionPerformed(e);
      }
    });
    jLabel11.setText("Manifest.mf contents");
    manifestScroll.setPreferredSize(new Dimension(200, 50));
    manifestText.setPreferredSize(new Dimension(200, 50));
    zipScroll.setPreferredSize(new Dimension(200, 50));
    encodingPanel.setLayout(encodingGridBag);
    encodingPanel.setBorder(etchedBorder);
    jLabel13.setDisplayedMnemonic('E');
    jLabel13.setLabelFor(entCheckBox);
    jLabel13.setText("Encoding");
    encodingField.setText("+p-m*t/d");
    jLabel12.setDisplayedMnemonic('U');
    jLabel12.setLabelFor(valueField);
    jLabel12.setText("Value");
    valueField.setText("1 + 2 * 3 - 4");
    resultButton.setMnemonic('R');
    resultButton.setText("Result");
    resultButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        resultButton_actionPerformed(e);
      }
    });
    resultField.setEditable(false);
    infoTab.setLayout(infoGridBag);
    jLabel14.setText("OS Name");
    osField.setEditable(false);
    osField.setText(Platform.OS_NAME);
    winCheckBox.setText("Windows");
    winCheckBox.setSelected(Platform.WIN32);
    unixCheckBox.setText("Unix");
    unixCheckBox.setHorizontalTextPosition(SwingConstants.LEADING);
    unixCheckBox.setSelected(Platform.UNIX);
    solarisCheckBox.setText("Solaris");
    solarisCheckBox.setSelected(Platform.SOLARIS);
    linuxCheckBox.setText("Linux");
    linuxCheckBox.setHorizontalTextPosition(SwingConstants.LEADING);
    linuxCheckBox.setSelected(Platform.LINUX);
    jLabel15.setText("User");
    jLabel16.setText("Company");
    userField.setEditable(false);
    userField.setText(JBuilderInfo.getUserName());
    companyField.setEditable(false);
    companyField.setText(JBuilderInfo.getCompanyName());
    jLabel17.setText("Description");
    jLabel18.setText("Build Number");
    descriptionField.setEditable(false);
    descriptionField.setText(JBuilderInfo.getDescription());
    descriptionField.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mouseClicked(MouseEvent e) {
        descriptionField_mouseClicked(e);
      }
    });
    numberField.setEditable(false);
    if (_minorVersion >= JB10_VERSION) {
      numberField.setText(JBuilderInfo.getBuildNumber());
    }
    licensedCheckBox.setText("Licensed");
    licensedCheckBox.setSelected(JBuilderInfo.isLicensed());
    trialCheckBox.setText("Trial");
    trialCheckBox.setHorizontalTextPosition(SwingConstants.LEADING);
    trialCheckBox.setSelected(JBuilderInfo.isTrial());
    proCheckBox.setText("Professional");
//    proCheckBox.setSelected(JBuilderInfo.isProEnabled());  // JBuilder 9-
    proCheckBox.setSelected(JBuilderInfo.isGenericValueEnabled());  // JBuilder 10+
    entCheckBox.setText("Enterprise");
    entCheckBox.setHorizontalTextPosition(SwingConstants.LEADING);
//    entCheckBox.setSelected(JBuilderInfo.isEntEnabled());  // JBuilder 9-
    entCheckBox.setSelected(JBuilderInfo.isGenericPremiumEnabled());  // JBuilder10+
    jLabel8.setDisplayedMnemonic('P');
    jLabel8.setLabelFor(proCheckBox);
    jLabel8.setText("ClipPathRenderer");
    clipCombo.setMinimumSize(new Dimension(100, 26));
    clipCombo.setPreferredSize(new Dimension(100, 26));
    clipCombo.setRenderer(new ClipPathRenderer());
    listTab.setLayout(listGridBag);
    jLabel4.setText("ListPanel");
    jLabel7.setText("DefaultDialog");
    simpleDialogButton.setMnemonic('S');
    simpleDialogButton.setText("Simple");
    simpleDialogButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        simpleDialogButton_actionPerformed(e);
      }
    });
    modalDialogButton.setMnemonic('M');
    modalDialogButton.setText("Modal");
    modalDialogButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        modalDialogButton_actionPerformed(e);
      }
    });
    validateDialogButton.setMnemonic('V');
    validateDialogButton.setText("Validate");
    validateDialogButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        validateDialogButton_actionPerformed(e);
      }
    });
    jLabel19.setText("ButtonStrip");
    jLabel9.setText("CompositeIcon");
    icon1Label.setText(" + ");
    icon1Label.setIcon(Icons.getIcon(this.getClass(), "/com/borland/jbuilder/wizard/archive/ArchiveWizard.gif"));
    icon2Label.setText(" = ");
    icon2Label.setIcon(Icons.getIcon(this.getClass(), "/com/borland/primetime/ide/image/error.gif"));
    icon3Label.setText(" ");
    icon3Label.setIcon(new CompositeIcon(new Icon[] {icon1Label.getIcon(), icon2Label.getIcon()}));
    disabledLabel.setHorizontalTextPosition(SwingConstants.LEADING);
    disabledLabel.setText("Disabled");
    disabledLabel.setIcon(new ImageIcon(image));
    disabledLabel.setIconTextGap(8);
    tableTab.setLayout(borderLayout1);
    jLabel1.setText("TableSorter");
    selectTopCheckBox.setText("Select top after sort");
    selectTopCheckBox.setMnemonic('S');
    selectTopCheckBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        selectTopCheckBox_actionPerformed(e);
      }
    });
    sorterScroll.setPreferredSize(new Dimension(300, 100));
    jLabel20.setText("SKU");
    skuField.setEditable(false);
    skuField.setText(JBuilderInfo.getSKUDescription());
    this.add(mainTabs, BorderLayout.CENTER);
    mainTabs.add(infoTab, "Info");
    mainTabs.add(colourTab, "Colour/Image");
    mainTabs.add(keystrokeTab, "Keystroke");
    mainTabs.add(listTab, "List");
    mainTabs.add(miscTab, "Misc");
    mainTabs.add(tableTab, "Table");
    mainTabs.add(zipTab, "Zip/CheckTree");
    colourTab.add(colorCombo, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(4, 4, 4, 4), 0, 0));
    colourTab.add(auraLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(4, 4, 4, 0), 0, 0));
    colourTab.add(colorPanel, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 4, 4, 4), 0, 0));
    colourTab.add(jLabel5, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(4, 4, 0, 4), 0, 0));
    colourTab.add(jLabel6, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(4, 4, 4, 4), 0, 0));
    colourTab.add(texturePanel, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(4, 4, 4, 4), 0, 0));
    colourTab.add(jLabel10, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(4, 4, 4, 4), 0, 0));
    colourTab.add(jLabel9, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    colourTab.add(jPanel1, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanel1.add(icon1Label, null);
    jPanel1.add(icon2Label, null);
    jPanel1.add(icon3Label, null);
    colourTab.add(disabledLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    keystrokeTab.add(keystrokeButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    keystrokeTab.add(keystrokePanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    zipTab.add(zipScroll, new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(4, 4, 4, 4), 0, 0));
    zipScroll.getViewport().add(zipTree, null);
    zipTab.add(zipLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(4, 4, 4, 4), 0, 0));
    zipTab.add(zipBrowseButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(4, 4, 4, 4), 0, 0));
    zipTab.add(manifestScroll, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(4, 4, 4, 4), 0, 0));
    zipTab.add(jLabel11, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 4, 0, 0), 0, 0));
    infoTab.add(jLabel14,   new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 4, 2, 4), 0, 0));
    infoTab.add(osField,     new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 4, 2, 4), 0, 0));
    infoTab.add(winCheckBox,   new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    infoTab.add(unixCheckBox,   new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    infoTab.add(solarisCheckBox,   new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    infoTab.add(linuxCheckBox,   new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    infoTab.add(jLabel15,   new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 4, 2, 4), 0, 0));
    infoTab.add(jLabel16,   new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 4, 2, 4), 0, 0));
    infoTab.add(userField,    new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 4, 2, 4), 0, 0));
    infoTab.add(companyField,    new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 4, 2, 4), 0, 0));
    infoTab.add(jLabel17,   new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 4, 2, 4), 0, 0));
    infoTab.add(jLabel18,   new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 4, 2, 4), 0, 0));
    infoTab.add(descriptionField,    new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 4, 2, 4), 0, 0));
    infoTab.add(licensedCheckBox,   new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    infoTab.add(trialCheckBox,   new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    infoTab.add(proCheckBox,   new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    infoTab.add(entCheckBox,   new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(2, 2, 2, 2), 0, 0));
    infoTab.add(numberField,     new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 4, 2, 4), 0, 0));
    infoTab.add(jLabel20,   new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 4, 2, 4), 0, 0));
    infoTab.add(skuField,    new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 4, 2, 4), 0, 0));
    miscTab.add(jLabel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(4, 4, 4, 0), 0, 0));
    miscTab.add(topCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 4, 0, 4), 0, 0));
    miscTab.add(bottomCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.SOUTH, GridBagConstraints.NONE, new Insets(0, 4, 0, 4), 0, 0));
    miscTab.add(leftCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(4, 4, 4, 4), 0, 0));
    miscTab.add(rightCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(4, 4, 4, 0), 0, 0));
    miscTab.add(encodingPanel, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    encodingPanel.add(jLabel13, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(4, 4, 4, 4), 0, 0));
    encodingPanel.add(encodingField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(4, 4, 4, 4), 0, 0));
    encodingPanel.add(jLabel12, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(4, 4, 4, 4), 0, 0));
    encodingPanel.add(valueField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(4, 4, 4, 4), 0, 0));
    encodingPanel.add(resultField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(4, 4, 4, 4), 0, 0));
    encodingPanel.add(resultButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(4, 4, 4, 4), 0, 0));
    miscTab.add(jLabel8, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(4, 4, 4, 4), 0, 0));
    miscTab.add(clipCombo, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(4, 4, 4, 100), 0, 0));
    miscTab.add(jLabel3, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(4, 4, 4, 4), 0, 0));
    miscTab.add(jLabel19, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(4, 4, 4, 4), 0, 0));
    miscTab.add(buttonStrip, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    miscTab.add(jLabel7, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(4, 4, 4, 4), 0, 0));
    miscTab.add(simpleDialogButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(4, 4, 4, 4), 0, 0));
    miscTab.add(modalDialogButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(4, 4, 4, 4), 0, 0));
    miscTab.add(validateDialogButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(4, 4, 4, 4), 0, 0));
    listTab.add(jLabel4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTHWEST, GridBagConstraints.HORIZONTAL, new Insets(4, 4, 4, 4), 0, 0));
    listTab.add(listPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    tableTab.add(jLabel1, BorderLayout.NORTH);
    tableTab.add(sorterScroll, BorderLayout.CENTER);
    tableTab.add(selectTopCheckBox, BorderLayout.SOUTH);
    sorterScroll.getViewport().add(sorterTable, null);
    manifestScroll.getViewport().add(manifestText, null);
    this.add(messageLabel, BorderLayout.SOUTH);
  }

  /** Further initialisation of contents. */
  private void fillData() {
    setAuraColour(Color.green);
    for (int index = 0; index < data.length; index++) {
      clipCombo.addItem(data[index]);
    }
    sorterModel.setModel(new DefaultTableModel(tableData, tableColumns));
    sorterTable.setModel(sorterModel);
    sorterModel.addMouseListenerToHeaderInTable(sorterTable);
    sorterModel.sortByColumn(1);
    JButton okButton = buttonStrip.createOkButton(true);
    okButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        okButton_actionPerformed(e);
      }
    });
    buttonStrip.createCancelButton(true);
    buttonStrip.createHelpButton(true);
  }

  /**
   * Bring up the keystroke dialog and display the result.
   *
   * @param  e  the triggering event
   */
  void keystrokeButton_actionPerformed(ActionEvent e) {
    KeyStrokeDialog dialog =
        new KeyStrokeDialog(this, "Select Keystroke", true);
    dialog.show();
    messageLabel.setText(
        KeyStrokeEditorPanel.getKeyStrokeText(dialog.getKeyStroke()));
  }

  /**
   * Gives notification that there was an insert into the keystroke field.
   *
   * @param  e  the triggering event
   */
  public void insertUpdate(DocumentEvent e) {
    messageLabel.setText(keystrokePanel.getJavaInitializationString());
  }

  /**
   * Gives notification that a portion of the keystroke field has been removed.
   *
   * @param  e  the triggering event
   */
  public void removeUpdate(DocumentEvent e) {
    messageLabel.setText(keystrokePanel.getJavaInitializationString());
  }

  /**
   * Gives notification that the keystroke field changed.
   *
   * @param  e  the triggering event
   */
  public void changedUpdate(DocumentEvent e) {
    messageLabel.setText(keystrokePanel.getJavaInitializationString());
  }

  /**
   * Update the aura colour based on the ColorPanel selection.
   *
   * @param  e  the triggering event
   */
  void colorPanel_actionPerformed(ActionEvent e) {
    setAuraColour(colorPanel.getSelectedColor());
  }

  /**
   * Update the aura colour based on the ColorCombo selection.
   *
   * @param  e  the triggering event
   */
  void colorCombo_actionPerformed(ActionEvent e) {
    setAuraColour(colorCombo.getSelectedColor());
  }

  /**
   * Update the aura colour and display results.
   *
   * @param  colour  the new aura colour
   */
  void setAuraColour(Color colour) {
    messageLabel.setText(colour.toString());
    aura.setAuraRGB(colour.getRGB());
    auraLabel.setIcon(new ImageIcon(aura.getBlendedImage()));
    disabledLabel.setIcon(
        new ImageIcon(Images.getDisabledImage(aura.getBlendedImage())));
  }

  /**
   * Modify which edges show for the EdgeBorder.
   *
   * @param  e  the triggering event
   */
  void edgeCheckBox_actionPerformed(ActionEvent e) {
    int edges = (topCheckBox.isSelected() ? 1 << 0 : 0) +
        (bottomCheckBox.isSelected() ? 1 << 8 : 0) +
        (leftCheckBox.isSelected() ? 1 << 4 : 0) +
        (rightCheckBox.isSelected() ? 1 << 12 : 0);
    jLabel2.setBorder(new EdgeBorder(edges));
  }

  /**
   * Browse for a new JAR/Zip file to open and
   * display its contents in a CheckTree.
   *
   * @param  e  the triggering event
   */
  void zipBrowseButton_actionPerformed(ActionEvent e) {
    JFileChooser chooser =
        new JFileChooser(FileSystemView.getFileSystemView());
    chooser.setDialogTitle("Open Zip File");
    chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
    chooser.setSelectedFile(new File(zipLabel.getText()));
    // Set filters for all, .jar, and .zip files, with the last as the default
    chooser.addChoosableFileFilter(chooser.getAcceptAllFileFilter());
    chooser.addChoosableFileFilter(new FileFilter() {
      public boolean accept(File file) {
        String path = file.getPath();
        return (file.isDirectory() || ((path.length() > 4) &&
            (path.substring(path.length() - 4).toLowerCase().equals(".jar"))));
      }
      public String getDescription() {
        return "JAR files";
      }
    });
    chooser.setFileFilter(new FileFilter() {
      public boolean accept(File file) {
        String path = file.getPath();
        return (file.isDirectory() || ((path.length() > 4) &&
            (path.substring(path.length() - 4).toLowerCase().equals(".zip"))));
      }
      public String getDescription() {
        return "Zip files";
      }
    });
    // Let the user select
    if (chooser.showOpenDialog(this) != JFileChooser.APPROVE_OPTION) {
      return;
    }
    String fileName = chooser.getSelectedFile().getAbsolutePath();
    ZipIndex zip = ZipIndex.getZipIndex(new File(fileName));
    zipLabel.setText(fileName);
    CheckTreeNode root = new CheckTreeNode("root");
    addFiles(root, zip, zip.getChildren(""));
    zipTree.setModel(new CheckTreeModel(root));
    zipTree.invalidate();
  }

  /**
   * Recursively add entries from a Zip file to the tree.
   *
   * @param  parent   the tree node to add to
   * @param  zip      the zip file
   * @param  entries  the entries in the zip file
   */
  private void addFiles(CheckTreeNode parent, ZipIndex zip,
      ZipIndexEntry[] entries) {
    for (int index = 0; index < entries.length; index++) {
      // Add a tree node - files are checkable
      CheckTreeNode child = new CheckTreeNode(entries[index].getName() + " ("  +
          new Date(entries[index].getLastModified()) + ")", true, false);
      parent.add(child);
      if (entries[index].getName().equals("MANIFEST.MF")) {
        // Display the contents of the manifest file
        try {
          manifestText.setText(new String(zip.read(entries[index])));
        }
        catch (IOException ioe) {
          ioe.printStackTrace();
        }
      }
      if (entries[index].isDirectory()) {
        addFiles(child, zip, zip.getChildren(entries[index].getDirectory() +
            (entries[index].getDirectory().length() > 0 ? File.separator : "") +
            entries[index].getName()));
      }
    }
  }

  /**
   * Apply a string encoding to given text.
   *
   * @param  e  the triggering event
   */
  void resultButton_actionPerformed(ActionEvent e) {
    StringEncoding encoding = new StringEncoding(encodingField.getText());
    resultField.setText(encoding.encode(valueField.getText()));
  }

  /**
   * Display the licensing information dialog.
   *
   * @param  e  the triggering event
   */
  void descriptionField_mouseClicked(MouseEvent e) {
    JBuilderInfo.showInfoDialog();
  }

  /**
   * Show a simple modal dialog.
   *
   * @param  e  the triggering event
   */
  void simpleDialogButton_actionPerformed(ActionEvent e) {
    DefaultDialog.showSimpleModalDialog(DefaultDialog.findFrame(this),
        "Simple Modal Dialog", new JButton("Your UI here"), null);
  }

  /**
   * Show a multi-button modal dialog.
   *
   * @param  e  the triggering event
   */
  void modalDialogButton_actionPerformed(ActionEvent e) {
    boolean OK = DefaultDialog.showModalDialog(DefaultDialog.findFrame(this),
        "Modal Dialog", new JButton("Your UI here"),
        PrimetimeHelp.TOPIC_DSelectFile);
    messageLabel.setText(OK ? "Dialog accepted" : "Dialog cancelled");
  }

  /**
   * Show a simple modal dialog, and validate on acceptance.
   *
   * @param  e  the triggering event
   */
  void validateDialogButton_actionPerformed(ActionEvent e) {
    final Frame frame = DefaultDialog.findFrame(this);
    boolean OK = DefaultDialog.showModalDialog(frame, "Validating Modal Dialog",
        new JButton("Your UI here"), PrimetimeHelp.TOPIC_DSelectFile,
        new DialogValidator() {
          public boolean validateDialog() {
            return (JOptionPane.showConfirmDialog(frame, "Is this valid?",
                "Sampler Validator", JOptionPane.YES_NO_OPTION) ==
                JOptionPane.YES_OPTION);
          }
        });
    messageLabel.setText(OK ? "Dialog accepted" : "Dialog cancelled");
  }

  /**
   * Bring up the package browse dialog and display the result.
   *
   * @param  e  the triggering event
   */
  void okButton_actionPerformed(ActionEvent e) {
    String className = PackageBrowserTree.browseClass(
        (JBProject)Browser.getActiveBrowser().getActiveProject(),
        this, "Select a class", "");
    messageLabel.setText(className == null || className.length() == 0 ?
        "Cancelled" : "Selected " + className);
  }

  /**
   * Alter the select top setting for the TableSorter.
   *
   * @param  e  the triggering event
   */
  void selectTopCheckBox_actionPerformed(ActionEvent e) {
    sorterModel.setSelectTopAfterSort(selectTopCheckBox.isSelected());
  }
}
