/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.xmltools;

import java.text.MessageFormat;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import wood.keith.opentools.xmltools.XMLValidator;
import wood.keith.opentools.xmltools.XSLTransformer;

class ToolsTableModel
extends DefaultTableModel {
    private static final String DEFAULT_MARKER = "   *";
    private boolean _isValidator = true;
    private static final String CAPTION = "XML Tools";
    private static final String CLASS_MISSING = "XML Tools class not found\n{0}";
    private static final String CLASS_BUILD = "XML Tools class not created\n{0}";
    static /* synthetic */ Class class$java$lang$String;

    public ToolsTableModel(boolean isValidator) {
        super(new String[]{"Def", "Name", "Class"}, 0);
        this._isValidator = isValidator;
    }

    public void setupColumns(JTable table) {
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setMaxWidth(27);
        column.setResizable(false);
    }

    public String[] getClassList() {
        String[] list = new String[this.getRowCount()];
        int index = 0;
        while (index < this.getRowCount()) {
            list[index] = (String)this.getValueAt(index, 2);
            ++index;
        }
        return list;
    }

    public void setClassList(String[] list) {
        this.getDataVector().clear();
        int index = 0;
        while (index < list.length) {
            this.addClass(list[index]);
            ++index;
        }
    }

    public void addClass(String className) {
        String name = "Unknown";
        try {
            if (this._isValidator) {
                XMLValidator xmlValidator = (XMLValidator)Class.forName(className).newInstance();
                name = xmlValidator.getValidatorName();
                xmlValidator = null;
            } else {
                XSLTransformer xslTransformer = (XSLTransformer)Class.forName(className).newInstance();
                name = xslTransformer.getTransformerName();
                xslTransformer = null;
            }
        }
        catch (ClassNotFoundException cnfe) {
            JOptionPane.showMessageDialog(null, MessageFormat.format(CLASS_MISSING, cnfe.getMessage()), CAPTION, 0);
            return;
        }
        catch (IllegalAccessException iae) {
            JOptionPane.showMessageDialog(null, MessageFormat.format(CLASS_BUILD, iae.getMessage()), CAPTION, 0);
            return;
        }
        catch (InstantiationException ie) {
            JOptionPane.showMessageDialog(null, MessageFormat.format(CLASS_BUILD, ie.getMessage()), CAPTION, 0);
            return;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), CAPTION, 0);
            return;
        }
        this.addRow(new String[]{"", name, className});
    }

    public void setDefault(int defaultItem) {
        int index = 0;
        while (index < this.getRowCount()) {
            this.setValueAt(index == defaultItem ? DEFAULT_MARKER : "", index, 0);
            ++index;
        }
    }

    public int getDefault() {
        int index = 0;
        while (index < this.getRowCount()) {
            if (this.getValueAt(index, 0).equals(DEFAULT_MARKER)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public Class getColumnClass(int columnIndex) {
        return class$java$lang$String == null ? (class$java$lang$String = ToolsTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

