/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.xmltools;

import com.borland.primetime.actions.UpdateAction;
import com.borland.primetime.editor.EditorContextActionProvider;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.BrowserAction;
import com.borland.primetime.ide.ContextActionProvider;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.TextFileNode;
import com.borland.primetime.vfs.Url;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import wood.keith.opentools.xmltools.XMLTools;
import wood.keith.opentools.xmltools.XMLToolsMenuGroup;

public abstract class XMLOpenFileMenu
implements ContextActionProvider,
EditorContextActionProvider {
    private static final String CAPTION = "Open {0}";
    private static final String LONG_DESC = "Open the {0} for this document";
    private static final String SAVE_SOURCE = "Please save the file before validating";
    private static final String OPEN_FAIL = "Couldn't open {0} {1}\n{2}";
    private static final String OPENING = "Opening {0} {1}";
    public final Action ACTION_PROJECT_OPEN_FILE = new BrowserAction(MessageFormat.format("Open {0}", this.getFileType()), '\u0000', MessageFormat.format("Open the {0} for this document", this.getFileType())){

        public void update(Browser browser) {
            String filename = null;
            try {
                filename = XMLOpenFileMenu.this.getRelatedFilename((TextFileNode)browser.getProjectView().getSelectedNode());
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (filename != null) {
                this.setLongText(MessageFormat.format(XMLOpenFileMenu.OPENING, XMLOpenFileMenu.this.getFileType(), filename));
            }
            ((AbstractAction)((Object)this)).setEnabled(filename != null);
        }

        public void actionPerformed(Browser browser) {
            XMLOpenFileMenu.this.doOpenAction(browser, browser.getProjectView().getSelectedNode());
        }
    };
    public final Action ACTION_EDITOR_OPEN_FILE = new UpdateAction(MessageFormat.format("Open {0}", this.getFileType()), '\u0000', MessageFormat.format("Open the {0} for this document", this.getFileType())){

        public void update(Object source) {
            String filename = null;
            try {
                filename = XMLOpenFileMenu.this.getRelatedFilename((TextFileNode)Browser.getActiveBrowser().getActiveNode());
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (filename != null) {
                this.setLongText(MessageFormat.format(XMLOpenFileMenu.OPENING, filename));
            }
            ((AbstractAction)((Object)this)).setEnabled(filename != null);
        }

        public void actionPerformed(ActionEvent e) {
            Browser browser = Browser.getActiveBrowser();
            XMLOpenFileMenu.this.doOpenAction(browser, browser.getActiveNode());
        }
    };

    public XMLOpenFileMenu() {
        XMLToolsMenuGroup.getMenuGroup().add(this.ACTION_EDITOR_OPEN_FILE);
        try {
            ImageIcon icon = new ImageIcon(ClassLoader.getSystemResource(this.getIconFilename()));
            ((UpdateAction)this.ACTION_PROJECT_OPEN_FILE).setSmallIcon((Icon)icon);
            ((UpdateAction)this.ACTION_EDITOR_OPEN_FILE).setSmallIcon((Icon)icon);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void doOpenAction(Browser browser, Node node) {
        block3: {
            if (!XMLTools.isXmlNode(node)) break block3;
            String relatedFilename = null;
            try {
                relatedFilename = this.getRelatedFilename((TextFileNode)node);
                if (relatedFilename != null) {
                    browser.doOpen(new Url(new File(relatedFilename)), browser.getActiveProject(), false);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog((Component)browser, MessageFormat.format(OPEN_FAIL, this.getFileType(), relatedFilename, ex.getMessage()), CAPTION, 0);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getRelatedFilename(TextFileNode node) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(node.getBuffer().getInputStream()));
        String relatedFilename = null;
        while ((line = reader.readLine()) != null) {
            void var3_4;
            relatedFilename = this.getFilenameFromLine((String)var3_4);
            if (relatedFilename == null) continue;
            if (relatedFilename.indexOf(File.separatorChar) != -1) break;
            relatedFilename = node.getUrl().getParent().getFile() + File.separatorChar + relatedFilename;
            break;
        }
        return relatedFilename;
    }

    protected abstract String getFilenameFromLine(String var1);

    protected abstract String getFileType();

    protected String getIconFilename() {
        return "";
    }

    public Action getContextAction(Browser browser, Node[] nodes) {
        if (nodes.length == 1 && XMLTools.isXmlNode(nodes[0])) {
            return this.ACTION_PROJECT_OPEN_FILE;
        }
        return null;
    }

    public Action getContextAction(EditorPane editor) {
        if (XMLTools.isXmlNode(Browser.getActiveBrowser().getActiveNode())) {
            return XMLToolsMenuGroup.getMenuGroup();
        }
        return null;
    }

    public int getPriority() {
        return 4;
    }
}

