/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.xmltools;

import com.borland.primetime.PrimeTime;
import com.borland.primetime.actions.UpdateAction;
import com.borland.primetime.editor.EditorAction;
import com.borland.primetime.editor.EditorContextActionProvider;
import com.borland.primetime.editor.EditorManager;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.BrowserAction;
import com.borland.primetime.ide.ContextActionProvider;
import com.borland.primetime.ide.ProjectView;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.TextFileNode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import wood.keith.opentools.xmltools.XMLTools;
import wood.keith.opentools.xmltools.XMLToolsMenuGroup;
import wood.keith.opentools.xmltools.XMLToolsPropertyGroup;
import wood.keith.opentools.xmltools.XMLValidator;

public class XMLValidateMenu
implements ContextActionProvider {
    private static XMLValidator _xmlValidator = null;
    private static final String CAPTION = "Validate XML";
    private static final String SAVE_SOURCE = "Please save the file before validating";
    private static final String VALIDATE_SUCCESS = "XML validation successful\n(checked by {0})";
    private static final String VALIDATE_FAIL = "XML validation failed\n(checked by {0})\n{1}";
    private static final String VALIDATE_FAIL_AT = "XML validation failed\n(checked by {0})\n{1}\nat line {2,number,integer}, column {3,number,integer}";
    private static final String USING = "Using {0}";
    private static final String VALIDATOR_MISSING = "XMLValidator class not found\n{0}";
    private static final String VALIDATOR_BUILD = "XMLValidator class not created\n{0}";
    public static final BrowserAction ACTION_PROJECT_VALIDATE_XML = new BrowserAction("Validate XML"){

        public void actionPerformed(Browser browser) {
            XMLValidateMenu.doValidateAction(browser, browser.getProjectView().getSelectedNode());
        }
    };
    private EditorContextActionProvider ValidateXML = new EditorContextActionProvider(){

        public Action getContextAction(EditorPane editor) {
            if (XMLTools.isXmlNode(Browser.getActiveBrowser().getActiveNode())) {
                return XMLToolsMenuGroup.getMenuGroup();
            }
            return null;
        }

        public int getPriority() {
            return 4;
        }
    };
    private static final UpdateAction ACTION_EDITOR_VALIDATE_XML = new UpdateAction("Validate XML"){

        public void update(Object source) {
            Node node = Browser.getActiveBrowser().getActiveNode();
            ((AbstractAction)((Object)this)).setEnabled(_xmlValidator != null && XMLTools.isXmlNode(node));
        }

        public void actionPerformed(ActionEvent e) {
            Browser browser = Browser.getActiveBrowser();
            XMLValidateMenu.doValidateAction(browser, browser.getActiveNode());
        }
    };

    public static void initOpenTool(byte majorVersion, byte minorVersion) {
        if (majorVersion != 4) {
            return;
        }
        XMLValidateMenu validateMenu = new XMLValidateMenu();
        ProjectView.registerContextActionProvider((ContextActionProvider)validateMenu);
        EditorManager.registerContextActionProvider((EditorContextActionProvider)validateMenu.ValidateXML);
        if (PrimeTime.isVerbose()) {
            System.out.println("Loaded XML Tools Validate menu v2.1");
            System.out.println("Written by Keith Wood (kbwood@iprimus.com.au)");
        }
    }

    public XMLValidateMenu() {
        String[] validatorList = XMLToolsPropertyGroup.VALIDATOR_LIST.getValues();
        int index = XMLToolsPropertyGroup.VALIDATOR.getInteger();
        String validatorClass = index < validatorList.length ? validatorList[index] : "wood.keith.opentools.xmltools.XMLJaxpValidator";
        XMLValidateMenu.setValidator(validatorClass);
    }

    public static void setValidator(String validatorClass) {
        try {
            _xmlValidator = null;
            _xmlValidator = (XMLValidator)Class.forName(validatorClass).newInstance();
            ACTION_PROJECT_VALIDATE_XML.setLongText(MessageFormat.format(USING, _xmlValidator.getValidatorName()));
            ACTION_EDITOR_VALIDATE_XML.setLongText(MessageFormat.format(USING, _xmlValidator.getValidatorName()));
        }
        catch (ClassNotFoundException cnfe) {
            JOptionPane.showMessageDialog((Component)Browser.getActiveBrowser(), MessageFormat.format(VALIDATOR_MISSING, cnfe.getMessage()), CAPTION, 0);
            _xmlValidator = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog((Component)Browser.getActiveBrowser(), MessageFormat.format(VALIDATOR_BUILD, ex.getMessage()), CAPTION, 0);
        }
    }

    private static void doValidateAction(Browser browser, Node node) {
        block4: {
            if (!XMLTools.isXmlNode(node)) break block4;
            try {
                InputSource xmlDocument = new InputSource(((TextFileNode)node).getBuffer().getInputStream());
                xmlDocument.setSystemId("file:///" + ((TextFileNode)node).getUrl().getFullName());
                _xmlValidator.validate(xmlDocument);
                JOptionPane.showMessageDialog((Component)browser, MessageFormat.format(VALIDATE_SUCCESS, _xmlValidator.getValidatorName()), CAPTION, 1);
            }
            catch (SAXParseException spe) {
                spe.printStackTrace();
                XMLValidateMenu.showError(MessageFormat.format(VALIDATE_FAIL_AT, _xmlValidator.getValidatorName(), spe.getMessage(), new Integer(spe.getLineNumber()), new Integer(spe.getColumnNumber())), browser, node, spe.getLineNumber(), spe.getColumnNumber());
            }
            catch (UnknownHostException uhe) {
                uhe.printStackTrace();
                XMLValidateMenu.showError(MessageFormat.format(VALIDATE_FAIL, _xmlValidator.getValidatorName(), "Unknown URL host: " + uhe.getMessage()), browser, node, -1, -1);
            }
            catch (Throwable th) {
                th.printStackTrace();
                XMLValidateMenu.showError(MessageFormat.format(VALIDATE_FAIL, _xmlValidator.getValidatorName(), th.getClass().getName() + " " + th.getMessage()), browser, node, -1, -1);
            }
        }
    }

    private static void showError(String message, Browser browser, Node node, int line, int column) {
        try {
            browser.openNodes(new Node[]{node}, node);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (line > -1) {
            EditorPane editor = EditorAction.getFocusedEditor();
            editor.gotoPosition(line, column, true);
        }
        JOptionPane.showMessageDialog((Component)browser, message, CAPTION, 0);
    }

    public Action getContextAction(Browser browser, Node[] nodes) {
        if (_xmlValidator != null && nodes.length == 1 && XMLTools.isXmlNode(nodes[0])) {
            return ACTION_PROJECT_VALIDATE_XML;
        }
        return null;
    }

    static {
        XMLToolsMenuGroup.getMenuGroup().add((Action)ACTION_EDITOR_VALIDATE_XML);
        try {
            ImageIcon validateIcon = new ImageIcon(ClassLoader.getSystemResource("wood/keith/opentools/xmltools/XMLVal16.gif"));
            ACTION_PROJECT_VALIDATE_XML.setSmallIcon((Icon)validateIcon);
            ACTION_EDITOR_VALIDATE_XML.setSmallIcon((Icon)validateIcon);
        }
        catch (Exception ex) {}
    }
}

