/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.xmltools;

import com.borland.jbuilder.editor.HTMLEditorKit;
import com.borland.jbuilder.editor.XMLEditorKit;
import com.borland.primetime.editor.EditorManager;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.node.TextFileNode;
import com.borland.primetime.vfs.Url;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import wood.keith.opentools.xmltools.XSLTViewerFactory;
import wood.keith.opentools.xmltools.XSLTransformer;

class XSLTViewer
extends JPanel
implements PropertyChangeListener {
    private TextFileNode _sourceNode;
    private XSLTransformer _xslTransformer;
    private static final String CAPTION = "XSLT Processing";
    private static final String MISSING_FILE = "The XSLT file does not exist";
    private static final String UPDATES_PENDING = "Please save the XML file before applying the transformation";
    private static final String TRANSFORM_FAIL = "Transformation failed\n{0}";
    private static final String TRANSFORM_FAIL_AT = "Transformation failed\n{0}\nat line {1,number,integer}, column {2,number,integer}";
    private static final String FIND_TITLE = "XSLT Document";
    private static final String XSL_FILE_DESC = "XSL files (*.xsl)";
    private static final String XSL_FILE_EXT = ".xsl";
    private BorderLayout _borderLayout = new BorderLayout();
    private JPanel jPanel1 = new JPanel();
    private JLabel jLabel1 = new JLabel();
    private JTextField _templateField = new JTextField();
    private JButton _browseButton = new JButton();
    private JButton _applyButton = new JButton();
    private GridBagLayout _gridBagLayout = new GridBagLayout();
    private JTabbedPane _resultsTabs = new JTabbedPane();
    private JScrollPane _viewScroll = new JScrollPane();
    private EditorPane _viewEditor = new EditorPane();
    private JScrollPane _sourceScroll = new JScrollPane();
    private EditorPane _sourceEditor = new EditorPane();
    private JScrollPane _templateScroll = new JScrollPane();
    private EditorPane _templateEditor = new EditorPane();
    private JPopupMenu _xsltPopup = new JPopupMenu();
    private JMenuItem _openTemplateItem = new JMenuItem();
    private HTMLEditorKit _htmlSourceKit = (HTMLEditorKit)EditorManager.getEditorKit((Class)(class$com$borland$jbuilder$editor$HTMLEditorKit == null ? (class$com$borland$jbuilder$editor$HTMLEditorKit = XSLTViewer.class$("com.borland.jbuilder.editor.HTMLEditorKit")) : class$com$borland$jbuilder$editor$HTMLEditorKit));
    private XMLEditorKit _xslSourceKit = (XMLEditorKit)EditorManager.getEditorKit((Class)(class$com$borland$jbuilder$editor$XMLEditorKit == null ? (class$com$borland$jbuilder$editor$XMLEditorKit = XSLTViewer.class$("com.borland.jbuilder.editor.XMLEditorKit")) : class$com$borland$jbuilder$editor$XMLEditorKit));
    static /* synthetic */ Class class$com$borland$jbuilder$editor$HTMLEditorKit;
    static /* synthetic */ Class class$com$borland$jbuilder$editor$XMLEditorKit;

    public XSLTViewer(TextFileNode sourceNode) {
        this._sourceNode = sourceNode;
        this._xslTransformer = XSLTViewerFactory.getTransformer();
        XSLTViewerFactory.addPropertyChangeListener(this);
        try {
            this.jbInit();
            this.setStylesheet();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this._borderLayout);
        this.jPanel1.setLayout(this._gridBagLayout);
        this.jLabel1.setDisplayedMnemonic('D');
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setLabelFor(this._templateField);
        this.jLabel1.setText("XSLT document");
        this._browseButton.setToolTipText("Find an XSLT document");
        this._browseButton.setMnemonic('B');
        this._browseButton.setText("Browse...");
        this._browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XSLTViewer.this.browseButton_actionPerformed(e);
            }
        });
        this._applyButton.setToolTipText("Apply using " + this._xslTransformer.getTransformerName());
        this._applyButton.setMnemonic('Y');
        this._applyButton.setText("Apply");
        this._applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XSLTViewer.this.applyButton_actionPerformed(e);
            }
        });
        this._resultsTabs.setTabPlacement(3);
        this._viewEditor.setContentType("text/html");
        this._viewEditor.setEditable(false);
        this._sourceEditor.setEditorKit((EditorKit)this._htmlSourceKit);
        this._sourceEditor.setEditable(false);
        this._templateEditor.setEditorKit((EditorKit)this._xslSourceKit);
        this._templateEditor.setEditable(false);
        this._templateEditor.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                XSLTViewer.this.templateEditor_mouseReleased(e);
            }
        });
        this._viewScroll.setToolTipText("Output from the transformation (displayed)");
        this._sourceScroll.setToolTipText("Output from the transformation (source)");
        this._templateScroll.setToolTipText("Transformation template source");
        this._openTemplateItem.setText("Open template");
        this._openTemplateItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XSLTViewer.this.openTemplateItem_actionPerformed(e);
            }
        });
        this.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 4, 2, 4), 0, 0));
        this.jPanel1.add((Component)this._templateField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 4, 2, 0), 0, 0));
        this.jPanel1.add((Component)this._applyButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 4, 2, 4), 0, 0));
        this.jPanel1.add((Component)this._browseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 4, 2, 4), 0, 0));
        this.add((Component)this._resultsTabs, "Center");
        this._resultsTabs.addTab("View", null, this._viewScroll, this._viewScroll.getToolTipText());
        this._resultsTabs.addTab("Source", null, this._sourceScroll, this._sourceScroll.getToolTipText());
        this._resultsTabs.addTab("Template", null, this._templateScroll, this._templateScroll.getToolTipText());
        this._viewScroll.getViewport().add((Component)this._viewEditor, null);
        this._sourceScroll.getViewport().add((Component)this._sourceEditor, null);
        this._templateScroll.getViewport().add((Component)this._templateEditor, null);
        this._xsltPopup.add(this._openTemplateItem);
        this._templateField.requestFocus();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals("xslTransformer")) {
            throw new UnsupportedOperationException("Unknown property " + evt.getPropertyName());
        }
        this._xslTransformer = (XSLTransformer)evt.getNewValue();
        this._applyButton.setToolTipText("Apply using " + this._xslTransformer.getTransformerName());
    }

    /*
     * WARNING - void declaration
     */
    private void setStylesheet() {
        String stylesheet = this._sourceNode.getUrl().getFileObject().getParent() + File.separatorChar;
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this._sourceNode.getBuffer().getInputStream()));
            while ((line = reader.readLine()) != null) {
                void var3_4;
                int pos = var3_4.indexOf("<?xml:stylesheet");
                if (pos == -1) {
                    pos = var3_4.indexOf("<?xml-stylesheet");
                }
                if (pos <= -1) continue;
                stylesheet = var3_4.substring(pos = var3_4.indexOf("href=\"", pos) + 6, var3_4.indexOf("\"", pos));
                if (stylesheet.indexOf(File.separatorChar) == -1) {
                    stylesheet = this._sourceNode.getUrl().getFileObject().getParent() + File.separatorChar + stylesheet;
                }
                break;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this._templateField.setText(stylesheet);
    }

    void browseButton_actionPerformed(ActionEvent e) {
        JFileChooser fileChooser = new JFileChooser(this._sourceNode.getUrl().getFileObject().getParent() + File.separatorChar, FileSystemView.getFileSystemView());
        fileChooser.setSelectedFile(new File(this._templateField.getText()));
        fileChooser.addChoosableFileFilter(fileChooser.getAcceptAllFileFilter());
        fileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String path = file.getPath();
                return file.isDirectory() || path.length() > XSLTViewer.XSL_FILE_EXT.length() && path.substring(path.length() - XSLTViewer.XSL_FILE_EXT.length()).toLowerCase().equals(XSLTViewer.XSL_FILE_EXT);
            }

            public String getDescription() {
                return XSLTViewer.XSL_FILE_DESC;
            }
        });
        fileChooser.setDialogTitle(FIND_TITLE);
        if (fileChooser.showOpenDialog((Component)Browser.getActiveBrowser()) == 0) {
            if (!fileChooser.getSelectedFile().exists()) {
                JOptionPane.showMessageDialog((Component)Browser.getActiveBrowser(), MISSING_FILE, CAPTION, 0);
                return;
            }
            this._templateField.setText(fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyButton_actionPerformed(ActionEvent e) {
        block7: {
            this._viewEditor.setText("");
            this._sourceEditor.setText("");
            this._templateEditor.setText("");
            File templateFile = new File(this._templateField.getText());
            if (!templateFile.exists()) {
                JOptionPane.showMessageDialog((Component)Browser.getActiveBrowser(), MISSING_FILE, CAPTION, 0);
                return;
            }
            try {
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    FileInputStream xsltIn = new FileInputStream(templateFile);
                    Document doc = this._templateEditor.getDocument();
                    this._templateEditor.getEditorKit().read(xsltIn, doc, 0);
                    this._templateEditor.gotoLine(1, false);
                    InputSource xmlDocument = new InputSource(this._sourceNode.getBuffer().getInputStream());
                    xmlDocument.setSystemId("file:///" + this._sourceNode.getUrl().getFullName());
                    InputSource xslDocument = new InputSource(new FileInputStream(templateFile));
                    xslDocument.setSystemId("file:///" + templateFile.getAbsolutePath());
                    String xsltResults = this._xslTransformer.transform(xmlDocument, xslDocument);
                    this._sourceEditor.setText(xsltResults);
                    this._sourceEditor.gotoLine(1, false);
                    this._viewEditor.setText(xsltResults);
                    this._viewEditor.gotoLine(1, false);
                    this._resultsTabs.setSelectedComponent(this._viewScroll);
                }
                catch (SAXParseException spe) {
                    spe.printStackTrace();
                    this.showError(MessageFormat.format(TRANSFORM_FAIL_AT, spe.getMessage(), new Integer(spe.getLineNumber()), new Integer(spe.getColumnNumber())), spe.getLineNumber(), spe.getColumnNumber());
                    Object var9_12 = null;
                    this.setCursor(Cursor.getDefaultCursor());
                    break block7;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.showError(MessageFormat.format(TRANSFORM_FAIL, ex.getClass().getName() + " " + ex.getMessage()), -1, -1);
                    Object var9_13 = null;
                    this.setCursor(Cursor.getDefaultCursor());
                    break block7;
                }
                catch (Error er) {
                    er.printStackTrace();
                    this.showError(MessageFormat.format(TRANSFORM_FAIL, er.getClass().getName() + " " + er.getMessage()), -1, -1);
                    Object var9_14 = null;
                    this.setCursor(Cursor.getDefaultCursor());
                }
                Object var9_11 = null;
                this.setCursor(Cursor.getDefaultCursor());
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                this.setCursor(Cursor.getDefaultCursor());
                throw throwable;
            }
        }
    }

    private void showError(String message, int line, int column) {
        JOptionPane.showMessageDialog((Component)Browser.getActiveBrowser(), message, CAPTION, 0);
        this._resultsTabs.setSelectedComponent(this._templateScroll);
        if (line != -1) {
            this._templateEditor.gotoPosition(line, column, true);
        }
    }

    void templateEditor_mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this._openTemplateItem.setEnabled(this._templateEditor.getText().length() > 0);
            this._xsltPopup.show((Component)this._templateEditor, e.getX(), e.getY());
        }
    }

    void openTemplateItem_actionPerformed(ActionEvent e) {
        File templateFile = new File(this._templateField.getText());
        if (templateFile.exists()) {
            Browser.getActiveBrowser().doOpen(new Url(templateFile), Browser.getActiveBrowser().getActiveProject(), false);
        }
    }

    public void setPosition(int lineNo) {
        this._templateEditor.gotoLine(lineNo + 1, false, 5);
        this._templateEditor.requestFocus();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

