/*
 * Decompiled with CFR 0.152.
 */
package wood.keith.opentools.xmltools;

import com.borland.primetime.PrimeTime;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.Context;
import com.borland.primetime.ide.NodeViewer;
import com.borland.primetime.ide.NodeViewerFactory;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.TextFileNode;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.EventListener;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import wood.keith.opentools.xmltools.XMLTools;
import wood.keith.opentools.xmltools.XMLToolsPropertyGroup;
import wood.keith.opentools.xmltools.XSLTNodeViewer;
import wood.keith.opentools.xmltools.XSLTransformer;

public class XSLTViewerFactory
implements NodeViewerFactory {
    public static final String XSL_TRANSFORMER_PROP = "xslTransformer";
    private static final String CAPTION = "XML Tools";
    private static final String TRANSFORMER_MISSING = "XSLTransformer class not found\n{0}";
    private static final String TRANSFORMER_BUILD = "XSLTransformer class not created\n{0}";
    private static EventListenerList _listenerList = new EventListenerList();
    private static XSLTransformer _xslTransformer = null;
    private static XSLTViewerFactory _xsltViewerFactory = new XSLTViewerFactory();
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    public static void initOpenTool(byte majorVersion, byte minorVersion) {
        if (majorVersion != 4) {
            return;
        }
        Browser.registerNodeViewerFactory((NodeViewerFactory)_xsltViewerFactory);
        if (PrimeTime.isVerbose()) {
            System.out.println("Loaded XSLT Viewer v2.1");
            System.out.println("Written by Keith Wood (kbwood@iprimus.com.au)");
        }
    }

    public boolean canDisplayNode(Node node) {
        return XMLTools.isXmlNode(node);
    }

    public NodeViewer createNodeViewer(Context context) {
        Node node = context.getNode();
        if (this.canDisplayNode(node)) {
            return new XSLTNodeViewer(context, (TextFileNode)node);
        }
        return null;
    }

    public static void setTransformer(String transformerClass) {
        try {
            XSLTransformer oldXslt = _xslTransformer;
            _xslTransformer = null;
            _xslTransformer = (XSLTransformer)Class.forName(transformerClass).newInstance();
            XSLTViewerFactory.firePropertyChange(XSL_TRANSFORMER_PROP, oldXslt, _xslTransformer);
            oldXslt = null;
        }
        catch (ClassNotFoundException cnfe) {
            JOptionPane.showMessageDialog((Component)Browser.getActiveBrowser(), MessageFormat.format(TRANSFORMER_MISSING, cnfe.getMessage()), CAPTION, 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog((Component)Browser.getActiveBrowser(), MessageFormat.format(TRANSFORMER_BUILD, ex.getMessage()), CAPTION, 0);
        }
    }

    public static XSLTransformer getTransformer() {
        return _xslTransformer;
    }

    public static void addPropertyChangeListener(PropertyChangeListener listener) {
        _listenerList.add(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = XSLTViewerFactory.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, listener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener listener) {
        _listenerList.remove(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = XSLTViewerFactory.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, listener);
    }

    public static void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        EventListener[] listeners = _listenerList.getListeners(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = XSLTViewerFactory.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener);
        PropertyChangeEvent event = null;
        int index = 0;
        while (index < listeners.length) {
            if (event == null) {
                event = new PropertyChangeEvent(_xsltViewerFactory, propertyName, oldValue, newValue);
            }
            ((PropertyChangeListener)listeners[index]).propertyChange(event);
            ++index;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String[] transformerList = XMLToolsPropertyGroup.TRANSFORMER_LIST.getValues();
        int index = XMLToolsPropertyGroup.TRANSFORMER.getInteger();
        String transformerClass = index < transformerList.length ? transformerList[index] : "wood.keith.opentools.xmltools.XSLTraxTransformer";
        XSLTViewerFactory.setTransformer(transformerClass);
    }
}

