package wood.keith.opentools.xmltools;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * Crimson implementation for validating an XML document.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  28 November 2003
 */
public class XMLJaxpValidator implements XMLValidator, ErrorHandler {

  // Singleton parser
  private static SAXParser _parser = null;
  // Do-nothing default handler
  private static final DefaultHandler HANDLER = new DefaultHandler();

  /**
   * Validate an XML document.
   *
   * @param  xmlDocument  a source representing the XML document to be validated
   * @throws  Exception  when an error occurs, may be a SAXParseException
   *                     showing line and column where the error occurred
   */
  public void validate(InputSource xmlDocument) throws Exception {
    // And parse it
    getParser().parse(xmlDocument, HANDLER);
  }

  /**
   * Return the singleton parser.
   *
   * @return  the validating parser object
   */
  private SAXParser getParser() throws SAXException {
    if (_parser == null) {
      // Create a new parser
      SAXParserFactory factory = SAXParserFactory.newInstance();
      // Request a validating parser
      factory.setNamespaceAware(true);
      factory.setValidating(true);
      try {
        _parser = factory.newSAXParser();
      }
      catch (ParserConfigurationException pce) {
        throw new SAXException(pce);
      }
      // Set error handler
      _parser.getParser().setErrorHandler(this);
    }
    return _parser;
  }

  /**
   * Return a description for this validation implementation.
   *
   * @return  the implementation's description
   */
  public String getValidatorName() {
    try {
      return "JAXP (" + getParser().getClass().getName() + ")";
    }
    catch (SAXException ex) {
      return "JAXP";
    }
  }

  /**
   * Implement ErrorHandler warning notification.
   *
   * @param  exception  the generated warning
   */
  public void warning(SAXParseException exception) throws SAXException {
    throw exception;
  }

  /**
   * Implement ErrorHandler error notification.
   *
   * @param  exception  the generated error
   */
  public void error(SAXParseException exception) throws SAXException {
    throw exception;
  }

  /**
   * Implement ErrorHandler fatal error notification.
   *
   * @param  exception  the generated fatal error
   */
  public void fatalError(SAXParseException exception) throws SAXException {
    throw exception;
  }
}
