package wood.keith.opentools.xmltools;

import com.borland.primetime.PrimeTime;
import com.borland.primetime.editor.EditorManager;
import com.borland.primetime.ide.ProjectView;

/**
 * Menu extensions for opening an XML document's stylesheet in JBuilder.
 *
 * There are several local context menus, and this class will
 * add entries to the local menu in the Project View, and also
 * to the local menu in the "source" window in the Content pane.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  16 October 2000
 * @version  2.0  15 February 2002
 */
public class XMLOpenStylesheetMenu extends XMLOpenFileMenu {

  /**
   * When the OpenTool add-ins are loaded, two ContextActionProviders
   * are registered, one for the Project Pane and one for the EditorPane.
   *
   * @param  majorVersion  the major version of the current OpenTools API
   * @param  minorVersion  the minor version of the current OpenTools API
   */
  public static void initOpenTool(byte majorVersion, byte minorVersion) {
    if (majorVersion != PrimeTime.CURRENT_MAJOR_VERSION) {
      return;
    }
    XMLOpenStylesheetMenu openStylesheet = new XMLOpenStylesheetMenu();
    ProjectView.registerContextActionProvider(openStylesheet);
    EditorManager.registerContextActionProvider(openStylesheet);
  }

  /**
   * Extract the name of the related file from this line of the
   * original document.
   * Here, find the stylesheet name from the appropriate processing instruction.
   *
   * @param  line  the line from the original document
   * @return  the name of the related file, or null if not found
   */
  protected String getFilenameFromLine(String line) {
    try {
      int pos = line.indexOf("<?xml:stylesheet");
      if (pos == -1) {
        pos = line.indexOf("<?xml-stylesheet");
      }
      if (pos > -1) {
        // Look for the stylesheet external reference (assumed to be on the same line)
        pos = line.indexOf("href=\"", pos) + 6;
        // And extract the file name
        return line.substring(pos, line.indexOf("\"", pos));
      }
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }
    return null;
  }

  /**
   * Retrieve a short description of the related file type.
   * Here, identify the stylesheet.
   *
   * @return  the type of file to be opened
   */
  protected String getFileType() { return "XSL stylesheet"; }

  /**
   * Retrieve the file name for an icon for this menu entry.
   * Here, return the stylesheet's icon.
   *
   * @return  the name of the file containing the image
   */
  protected String getIconFilename() {
    return "wood/keith/opentools/xmltools/XMLXSL16.gif";
  }
}
