package wood.keith.opentools.xmltools;

import com.borland.jbuilder.node.XMLFileNode;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.TextFileNode;

/**
 * Common values and methods for XML Tools.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  2.0  15 February 2002.
 * @version  2.1  28 November 2003.
 */
public class XMLTools {

  public static final String VERSION = "2.1";

  /**
   * Determine whether or not the given node contains XML.
   * In some versions of JBuilder XML nodes have their own node type
   * (XMLFileNode). Otherwise we need to check the file extension.
   *
   * @param  node  the node to test
   * @return  true if the node is a TextFileNode and contains XML,
   *          false otherwise
   */
  public static boolean isXmlNode(Node node) {
    String extension = (node instanceof TextFileNode ?
        ((TextFileNode)node).getUrl().getFileExtension() : "");
    return (node instanceof XMLFileNode ||
        (extension.equals("xml") || extension.equals("xsl") ||
        extension.equals("xsd") || extension.equals("wml") ||
        extension.equals("tld")));
  }

  private XMLTools() {
  }
}
