package wood.keith.opentools.xmltools;

import com.borland.primetime.actions.ActionGroup;

/**
 * Single menu group for all XML Tools menu items.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  16 October 2000
 */
public class XMLToolsMenuGroup extends ActionGroup {

  /** Singleton menu group. */
  private static XMLToolsMenuGroup _menuGroup;

  /** Private constructor to enforce singleton. */
  private XMLToolsMenuGroup() {
  }

  /**
   * Retrieve the singleton menu group.
   *
   * @return  the XML tools menu group
   */
  public static XMLToolsMenuGroup getMenuGroup() {
    if (_menuGroup == null) {
      _menuGroup = new XMLToolsMenuGroup();
    }
    return _menuGroup;
  }
}