package wood.keith.opentools.xmltools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

import com.borland.jbuilder.ide.PackageBrowserTree;
import com.borland.jbuilder.node.JBProject;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.help.HelpTopic;
import com.borland.primetime.help.ZipHelpBook;
import com.borland.primetime.help.ZipHelpTopic;
import com.borland.primetime.properties.PropertyPage;

/**
 * This is the property page that modifies the "XML Tools" parameters being
 * saved in user.properties.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  16 October 2000
 * @version  2.0  15 February 2002
 */
public class XMLToolsPropertyPage extends PropertyPage {

  private GridLayout _gridLayout = new GridLayout();
  private JPanel _validatorPanel = new JPanel();
  private JPanel _transformerPanel = new JPanel();
  private Border _border1;
  private TitledBorder _titledBorder1;
  private Border _border2;
  private TitledBorder _titledBorder2;
  private GridBagLayout _gridBagLayout1 = new GridBagLayout();
  private GridBagLayout _gridBagLayout2 = new GridBagLayout();
  private JLabel jLabel2 = new JLabel();
  private JTextField _validatorField = new JTextField();
  private JButton _browseValidatorButton = new JButton();
  private JButton _addValidatorButton = new JButton();
  private JButton _deleteValidatorButton = new JButton();
  private JButton _defaultValidatorButton = new JButton();
  private JScrollPane _validatorScroll = new JScrollPane();
  private JTable _validatorTable = new ToolTipTable();
  private ToolsTableModel _validatorModel = new ToolsTableModel(true);
  private JTableHeader _validatorHeader = new ToolTipTableHeader();
  private JLabel jLabel4 = new JLabel();
  private JTextField _transformerField = new JTextField();
  private JButton _browseTransformerButton = new JButton();
  private JButton _addTransformerButton = new JButton();
  private JButton _deleteTransformerButton = new JButton();
  private JButton _defaultTransformerButton = new JButton();
  private JScrollPane _transformerScroll = new JScrollPane();
  private JTable _transformerTable = new ToolTipTable();
  private ToolsTableModel _transformerModel = new ToolsTableModel(false);
  private JTableHeader _transformerHeader = new ToolTipTableHeader();
  private DocumentListener _textListener = new DocumentListener() {
    public void insertUpdate(DocumentEvent e) {
      disEnableButtons();
    }
    public void removeUpdate(DocumentEvent e) {
      disEnableButtons();
    }
    public void changedUpdate(DocumentEvent e) {
      disEnableButtons();
    }
  };

  public XMLToolsPropertyPage() {
    try {
      jbInit();
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }
  }

  /**
   * Define the user interface.
   * The user interface is constructed here so the JBuilder UI Designer
   * may be used to edit it.
   */
  protected void jbInit() throws Exception {
    _border1 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
    _titledBorder1 = new TitledBorder(_border1,"XML Validator");
    _border2 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
    _titledBorder2 = new TitledBorder(_border2,"XSL Transformer");
    _gridLayout.setRows(2);
    _gridLayout.setColumns(1);
    this.setLayout(_gridLayout);
    _validatorPanel.setBorder(_titledBorder1);
    _validatorPanel.setLayout(_gridBagLayout1);
    _transformerPanel.setBorder(_titledBorder2);
    _transformerPanel.setLayout(_gridBagLayout2);
    jLabel2.setToolTipText("");
    jLabel2.setDisplayedMnemonic('C');
    jLabel2.setLabelFor(_validatorField);
    jLabel2.setText("Class name");
    _validatorField.getDocument().addDocumentListener(_textListener);
    _addValidatorButton.setText("Add");
    _addValidatorButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        addValidatorButton_actionPerformed(e);
      }
    });
    _deleteValidatorButton.setText("Delete");
    _deleteValidatorButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        deleteValidatorButton_actionPerformed(e);
      }
    });
    _defaultValidatorButton.setText("Default");
    _defaultValidatorButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        defaultValidatorButton_actionPerformed(e);
      }
    });
    _validatorTable.setModel(_validatorModel);
    _validatorModel.setupColumns(_validatorTable);
    _validatorTable.setTableHeader(_validatorHeader);
    _validatorTable.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mouseClicked(MouseEvent e) {
        validatorTable_mouseClicked(e);
      }
    });
    _validatorHeader.setColumnModel(_validatorTable.getColumnModel());
    jLabel4.setToolTipText("");
    jLabel4.setDisplayedMnemonic('N');
    jLabel4.setLabelFor(_transformerField);
    jLabel4.setText("Class name");
    _transformerField.getDocument().addDocumentListener(_textListener);
    _addTransformerButton.setText("Add");
    _deleteTransformerButton.setText("Delete");
    _deleteTransformerButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        deleteTransformerButton_actionPerformed(e);
      }
    });
    _defaultTransformerButton.setText("Default");
    _defaultTransformerButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        defaultTransformerButton_actionPerformed(e);
      }
    });
    _addTransformerButton.setText("Add");
    _addTransformerButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        addTransformerButton_actionPerformed(e);
      }
    });
    _transformerTable.setModel(_transformerModel);
    _transformerModel.setupColumns(_transformerTable);
    _transformerTable.setTableHeader(_transformerHeader);
    _transformerTable.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mouseClicked(MouseEvent e) {
        transformerTable_mouseClicked(e);
      }
    });
    _transformerHeader.setColumnModel(_transformerTable.getColumnModel());
    _validatorScroll.setPreferredSize(new Dimension(300, 100));
    _transformerScroll.setPreferredSize(new Dimension(300, 100));
    _validatorField.setToolTipText("Enter the name of the validator adapter class");
    _transformerField.setToolTipText("Enter the name of the transformer adapter class");
    _browseTransformerButton.setToolTipText("Find a transformer adapter");
    _browseTransformerButton.setMargin(new Insets(2, 4, 2, 4));
    _browseTransformerButton.setMnemonic('W');
    _browseTransformerButton.setText("Browse");
    _browseTransformerButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        browseTransformerButton_actionPerformed(e);
      }
    });
    _browseValidatorButton.setToolTipText("Find a validator adapter");
    _browseValidatorButton.setMargin(new Insets(2, 4, 2, 4));
    _browseValidatorButton.setMnemonic('B');
    _browseValidatorButton.setText("Browse");
    _browseValidatorButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        browseValidatorButton_actionPerformed(e);
      }
    });
    this.add(_validatorPanel, null);
    _validatorPanel.add(jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 2, 2, 2), 0, 0));
    _validatorPanel.add(_validatorField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 2, 2, 2), 0, 0));
    _validatorPanel.add(_addValidatorButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 2, 2, 2), 0, 0));
    _validatorPanel.add(_deleteValidatorButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 2, 2, 2), 0, 0));
    _validatorPanel.add(_defaultValidatorButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(2, 2, 2, 2), 0, 0));
    _validatorPanel.add(_validatorScroll, new GridBagConstraints(1, 1, 1, GridBagConstraints.REMAINDER, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(2, 2, 2, 2), 0, 0));
    _validatorPanel.add(_browseValidatorButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 2, 2, 2), 0, 0));
    _validatorScroll.getViewport().add(_validatorTable, null);
    this.add(_transformerPanel, null);
    _transformerPanel.add(jLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 2, 2, 2), 0, 0));
    _transformerPanel.add(_transformerField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 2, 2, 2), 0, 0));
    _transformerPanel.add(_addTransformerButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 2, 2, 2), 0, 0));
    _transformerPanel.add(_deleteTransformerButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 2, 2, 2), 0, 0));
    _transformerPanel.add(_defaultTransformerButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(2, 2, 2, 2), 0, 0));
    _transformerPanel.add(_transformerScroll, new GridBagConstraints(1, 1, 1, GridBagConstraints.REMAINDER, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(2, 2, 2, 2), 0, 0));
    _transformerPanel.add(_browseTransformerButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 2, 2, 2), 0, 0));
    _transformerScroll.getViewport().add(_transformerTable, null);
    _addValidatorButton.setMnemonic('A');
    _deleteValidatorButton.setMnemonic('E');
    _addValidatorButton.setToolTipText("Add this validator adapter class to the list");
    _deleteValidatorButton.setToolTipText("Remove the validator adapter class from the list");
    _deleteValidatorButton.setMargin(new Insets(2, 4, 2, 4));
    _addValidatorButton.setMargin(new Insets(2, 4, 2, 4));
    _defaultValidatorButton.setMargin(new Insets(2, 4, 2, 4));
    _defaultValidatorButton.setToolTipText("Make the validator adapter the default");
    _defaultValidatorButton.setMnemonic('F');
    _addTransformerButton.setMargin(new Insets(2, 4, 2, 4));
    _addTransformerButton.setMnemonic('D');
    _addTransformerButton.setToolTipText("Add this transformer adapter class to the list");
    _deleteTransformerButton.setToolTipText("Remove the validator transformer class from the list");
    _deleteTransformerButton.setMnemonic('L');
    _deleteTransformerButton.setMargin(new Insets(2, 4, 2, 4));
    _defaultTransformerButton.setMargin(new Insets(2, 4, 2, 4));
    _defaultTransformerButton.setToolTipText("Make the transformer adapter the default");
    _defaultTransformerButton.setMnemonic('U');
    disEnableButtons();
  }

  /**
   * Set button availability based on other values.
   */
  private void disEnableButtons() {
    _addValidatorButton.setEnabled(_validatorField.getText().length() > 0);
    _deleteValidatorButton.setEnabled(_validatorTable.getSelectedRow() > -1);
    _defaultValidatorButton.setEnabled(_validatorTable.getSelectedRow() > -1);
    _addTransformerButton.setEnabled(_transformerField.getText().length() > 0);
    _deleteTransformerButton.setEnabled(_transformerTable.getSelectedRow() > -1);
    _defaultTransformerButton.setEnabled(_transformerTable.getSelectedRow() > -1);
  }

  /**
   * Find a validator.
   */
  void browseValidatorButton_actionPerformed(ActionEvent e) {
    String validatorClass = PackageBrowserTree.browseClass(
        (JBProject)Browser.getActiveBrowser().getActiveProject(), this,
        "Find Validator Adapter", _validatorField.getText());
    if (validatorClass != null) {
      _validatorField.setText(validatorClass);
    }
  }

  /**
   * Add a new validator.
   */
  void addValidatorButton_actionPerformed(ActionEvent e) {
    _validatorModel.addClass(_validatorField.getText());
    disEnableButtons();
  }

  /**
   * Remove an existing validator.
   */
  void deleteValidatorButton_actionPerformed(ActionEvent e) {
    _validatorModel.removeRow(_validatorTable.getSelectedRow());
    disEnableButtons();
  }

  /**
   * Make the current validator the default.
   */
  void defaultValidatorButton_actionPerformed(ActionEvent e) {
    _validatorModel.setDefault(_validatorTable.getSelectedRow());
  }

  /**
   * Double-click is the same as default button.
   */
  void validatorTable_mouseClicked(MouseEvent e) {
    if (e.getClickCount() == 2 && _defaultValidatorButton.isEnabled()) {
      _defaultValidatorButton.doClick();
    }
  }

  /**
   * Find a transformer.
   */
  void browseTransformerButton_actionPerformed(ActionEvent e) {
    String transformerClass = PackageBrowserTree.browseClass(
      (JBProject)Browser.getActiveBrowser().getActiveProject(), this,
      "Find Transformer Adapter", _transformerField.getText());
    if (transformerClass != null) {
      _transformerField.setText(transformerClass);
    }
  }

  /**
   * Add a new transformer.
   */
  void addTransformerButton_actionPerformed(ActionEvent e) {
    _transformerModel.addClass(_transformerField.getText());
    disEnableButtons();
  }

  /**
   * Remove an existing transformer.
   */
  void deleteTransformerButton_actionPerformed(ActionEvent e) {
    _transformerModel.removeRow(_transformerTable.getSelectedRow());
    disEnableButtons();
  }

  /**
   * Make the current transformer the default.
   */
  void defaultTransformerButton_actionPerformed(ActionEvent e) {
    _transformerModel.setDefault(_transformerTable.getSelectedRow());
  }

  /**
   * Double-click is the same as default button.
   */
  void transformerTable_mouseClicked(MouseEvent e) {
    if (e.getClickCount() == 2 && _defaultTransformerButton.isEnabled()) {
      _defaultTransformerButton.doClick();
    }
  }

  /**
   * Initialize the UI.
   *
   * Loads the current property values into the user interface in
   * preparation for displaying the page to the user.
   */
  public void readProperties() {
    _validatorModel.setClassList(
        XMLToolsPropertyGroup.VALIDATOR_LIST.getValues());
    int defaultItem = XMLToolsPropertyGroup.VALIDATOR.getInteger();
    _validatorModel.setDefault(defaultItem);
    if (_validatorTable.getRowCount() > 0) {
      _validatorTable.addRowSelectionInterval(defaultItem, defaultItem);
    }
    _transformerModel.setClassList(
        XMLToolsPropertyGroup.TRANSFORMER_LIST.getValues());
    defaultItem = XMLToolsPropertyGroup.TRANSFORMER.getInteger();
    _transformerModel.setDefault(defaultItem);
    if (_transformerTable.getRowCount() > 0) {
      _transformerTable.addRowSelectionInterval(defaultItem, defaultItem);
    }
    disEnableButtons();
  }

  /**
   * Check for user input errors.
   *
   * Verify user input.  If any errors, should call reportValidationError()
   * for the first error found and return false here.
   *
   * @return  false if the page contains invalid user settings, true otherwise.
   */
  public boolean isValid() { return true; }

  /**
   * Commit changes to properties.
   *
   * Saves updated property values from the property page user interface
   * back to the appropriate properties.  This method will only be invoked if
   * isValid() returns true.
   */
  public void writeProperties() {
    XMLToolsPropertyGroup.VALIDATOR_LIST.setValues(_validatorModel.getClassList());
    XMLToolsPropertyGroup.VALIDATOR.setInteger(_validatorModel.getDefault());
    XMLValidateMenu.setValidator(
        (String)_validatorModel.getValueAt(_validatorTable.getSelectedRow(), 2));

    XMLToolsPropertyGroup.TRANSFORMER_LIST.setValues(_transformerModel.getClassList());
    XMLToolsPropertyGroup.TRANSFORMER.setInteger(_transformerModel.getDefault());
    XSLTViewerFactory.setTransformer(
        (String)_transformerModel.getValueAt(_transformerTable.getSelectedRow(), 2));
  }

  /**
   * Define the help topic object associated with this property page.
   * This will be displayed when Help is selected from the containing dialog.
   *
   * @return  the topic for this property page
   */
  public HelpTopic getHelpTopic() {
    return new ZipHelpTopic(new ZipHelpBook("XMLToolsDoc.jar"),
        "wood/keith/opentools/xmltools/XMLToolsPropertyPage.html");
  }
}

/**
 * Show cell tips in the table.
 */
class ToolTipTable extends JTable {

  /**
   * Return the text in the cell at the current mouse position within the table.
   *
   * @param  e  the mouse event hovering over the table
   */
  public String getToolTipText(MouseEvent e) {
    if ((rowAtPoint(e.getPoint()) == -1) ||
        (columnAtPoint(e.getPoint()) == -1)) {
      return null;
    }

    String value = getValueAt(rowAtPoint(e.getPoint()),
        columnAtPoint(e.getPoint())).toString();
    FontMetrics fm = getFontMetrics(getFont());
    int widthValue = fm.stringWidth(value);
    int widthColumn = getColumnModel().
        getColumn(columnAtPoint(e.getPoint())).getWidth() - 3;
    if (widthValue < widthColumn) {
      value = "";
    }
    return (value.equals("") ? null : value);
  }
}

/**
 * Show cell tips in the table header.
 */
class ToolTipTableHeader extends JTableHeader {

  /**
   * Return the text in the cell at the current mouse position
   * within the table header.
   *
   * @param  e  the mouse event hovering over the table
   */
  public String getToolTipText(MouseEvent e) {
    if (columnAtPoint(e.getPoint()) == -1) {
      return null;
    }

    TableColumn column =
        getColumnModel().getColumn(columnAtPoint(e.getPoint()));
    String value = column.getHeaderValue().toString();
    FontMetrics fm = getFontMetrics(getFont());
    int widthValue = fm.stringWidth(value);
    int widthColumn = column.getWidth() + 2;
    if (widthValue < widthColumn) {
      value = "";
    }
    return (value.equals("") ? null : value);
  }
}

/**
 * Table model for the classes that implement the various XML Tools.
 */
class ToolsTableModel extends DefaultTableModel {

  private static final String DEFAULT_MARKER = "   *";
  private boolean _isValidator = true;

  private static final String CAPTION       = "XML Tools";
  private static final String CLASS_MISSING = "XML Tools class not found\n{0}";
  private static final String CLASS_BUILD   =
      "XML Tools class not created\n{0}";

  /**
   * Create a new table model with these columns.
   *
   * @param  isValidator  true if this model is for XML validators,
   *                      false if it is for XSL Transformers
   */
  public ToolsTableModel(boolean isValidator) {
    super(new String[] {"Def", "Name", "Class"}, 0);
    _isValidator = isValidator;
  }

  /**
   * Establish look for columns.
   *
   * @param  table  the table for this model
   */
  public void setupColumns(JTable table) {
    TableColumn column = table.getColumnModel().getColumn(0);
    column.setMaxWidth(27);
    column.setResizable(false);
  }

  /**
   * Return the list of class names.
   *
   * @return  the list
   */
  public String[] getClassList() {
    String[] list = new String[getRowCount()];
    for (int index = 0; index < getRowCount(); index++) {
      list[index] = (String)getValueAt(index, 2);
    }
    return list;
  }

  /**
   * Load a list of classes.
   *
   * @param  list  the list of class names
   */
  public void setClassList(String[] list) {
    getDataVector().clear();
    for (int index = 0; index < list.length; index++) {
      addClass(list[index]);
    }
  }

  /**
   * Add a single class to the table - finding its display name.
   *
   * @param  className  the name of the class to add
   */
  public void addClass(String className) {
    String name = "Unknown";
    try {
      if (_isValidator) {
        XMLValidator xmlValidator =
            (XMLValidator)Class.forName(className).newInstance();
        name = xmlValidator.getValidatorName();
        xmlValidator = null;
      }
      else {
        XSLTransformer xslTransformer =
            (XSLTransformer)Class.forName(className).newInstance();
        name = xslTransformer.getTransformerName();
        xslTransformer = null;
      }
    }
    catch (ClassNotFoundException cnfe) {
      JOptionPane.showMessageDialog(null,
          MessageFormat.format(CLASS_MISSING, new Object[] {cnfe.getMessage()}),
          CAPTION, JOptionPane.ERROR_MESSAGE);
      return;
    }
    catch (IllegalAccessException iae) {
      JOptionPane.showMessageDialog(null,
          MessageFormat.format(CLASS_BUILD, new Object[] {iae.getMessage()}),
          CAPTION, JOptionPane.ERROR_MESSAGE);
      return;
    }
    catch (InstantiationException ie) {
      JOptionPane.showMessageDialog(null,
          MessageFormat.format(CLASS_BUILD, new Object[] {ie.getMessage()}),
          CAPTION, JOptionPane.ERROR_MESSAGE);
      return;
    }
    catch (Exception ex) {
      JOptionPane.showMessageDialog(null,
          ex.getMessage(), CAPTION, JOptionPane.ERROR_MESSAGE);
      return;
    }
    addRow(new String[] {"", name, className});
  }

  /**
   * Set the default item.
   *
   * @param  defaultItem  the index of the default class
   */
  public void setDefault(int defaultItem) {
    for (int index = 0; index < getRowCount(); index++) {
      setValueAt((index == defaultItem ? DEFAULT_MARKER : ""), index, 0);
    }
  }

  /**
   * Return the selected default class' index.
   *
   * @return  the index of the default item
   */
  public int getDefault() {
    for (int index = 0; index < getRowCount(); index++) {
      if (getValueAt(index, 0).equals(DEFAULT_MARKER)) {
        return index;
      }
    }
    return -1;
  }

  /**
   *  All columns are strings.
   *
   *  @param  columnIndex  the column being queried
   *  @return  the String class
   */
  public Class getColumnClass(int columnIndex) { return String.class; }

  /**
   *  Returns false.  This is the default implementation for all cells.
   *
   *  @param  rowIndex     the row being queried
   *  @param  columnIndex  the column being queried
   *  @return  false
   */
  public boolean isCellEditable(int rowIndex, int columnIndex) { return false; }
}
