package wood.keith.opentools.xmltools;

import org.xml.sax.InputSource;

/**
 * Interface for validating an XML document.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  16 October 2000
 * @version  2.0  15 February 2002
 */
public interface XMLValidator {

  /**
   * Validate an XML document.
   *
   * @param  xmlDocument  a source representing the XML document to be validated
   * @throws  Exception  when an error occurs, may be a SAXParseException
   *                     showing line and column where the error occurred
   */
  public void validate(InputSource xmlDocument) throws Exception;

  /**
   * Return a description for this validation implementation.
   *
   * @return  the implementation's description
   */
  public String getValidatorName();
}