package wood.keith.opentools.xmltools;

import org.apache.xerces.parsers.SAXParser;

import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/**
 * Xerces 2 implementation for validating an XML document.
 * For more details see http://xml.apache.org/xerces-j/index.html.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  16 October 2000
 * @version  2.0  15 February 2002
 */
public class XMLXerces2Validator implements XMLValidator, ErrorHandler {

  // Singleton parser
  private static SAXParser _parser = null;

  /**
   * Validate an XML document.
   *
   * @param  xmlDocument  a source representing the XML document to be validated
   * @throws  Exception  when an error occurs, may be a SAXParseException
   *                     showing line and column where the error occurred
   */
  public void validate(InputSource xmlDocument) throws Exception {
    // And parse it
    getParser().parse(xmlDocument);
  }

  /**
   * Return the singleton parser.
   *
   * @return  the validating parser object
   */
  private SAXParser getParser() throws SAXException {
    if (_parser == null) {
      // Create a new parser
      _parser = new SAXParser();
      // Turn on validation
      _parser.setFeature("http://xml.org/sax/features/validation", true);
      // Set error handler
      _parser.setErrorHandler(this);
    }
    return _parser;
  }

  /**
   * Return a description for this validation implementation.
   *
   * @return  the implementation's description
   */
  public String getValidatorName() {
    return "Xerces 2 (SAX) from Apache";
  }

  /**
   * Implement ErrorHandler warning notification.
   *
   * @param  exception  the generated warning
   */
  public void warning(SAXParseException exception) throws SAXException {
    throw exception;
  }

  /**
   * Implement ErrorHandler error notification.
   *
   * @param  exception  the generated error
   */
  public void error(SAXParseException exception) throws SAXException {
    throw exception;
  }

  /**
   * Implement ErrorHandler fatal error notification.
   *
   * @param  exception  the generated fatal error
   */
  public void fatalError(SAXParseException exception) throws SAXException {
    throw exception;
  }
}