package wood.keith.opentools.xmltools;

import java.io.StringWriter;

import com.icl.saxon.ExtendedInputSource;
import com.icl.saxon.trax.Processor;
import com.icl.saxon.trax.ProcessorFactoryException;
import com.icl.saxon.trax.Result;
import com.icl.saxon.trax.Templates;
import com.icl.saxon.trax.Transformer;

import org.xml.sax.InputSource;

/**
 * SAXON 5.5.1 interface for applying an XSL Transformation to a document.
 * For more details see http://users.iclway.co.uk/mhkay/saxon/.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  16 October 2000
 * @version  2.0  15 February 2002
 */
public class XSLSaxon551Transformer implements XSLTransformer {

  // Singleton processor
  private static Processor _processor = null;

  /**
   * Apply an XSL transformation to a document.
   *
   * @param  xmlDocument  a source representing the XML document to be transformed
   * @param  xslDocument  a source representing the XSL transformation
   * @return  the text resulting from the transformation process
   * @throws  Exception  when an error occurs, may be a SAXParseException
   *                     showing line and column where the error occurred
   */
  public String transform(InputSource xmlDocument, InputSource xslDocument)
      throws Exception {
    // Create the compiled transformation
    Templates xsltTemplates =
      getProcessor().process(new ExtendedInputSource(xslDocument));
    Transformer xsltTransform = xsltTemplates.newTransformer();
    // Apply the transformation
    StringWriter out = new StringWriter();
    xsltTransform.transform(
      new ExtendedInputSource(xmlDocument), new Result(out));
    // Return the results
    return out.toString();
  }

  /**
   * Return the singleton processor.
   *
   * @return  the XSLT processor
   */
  private Processor getProcessor() throws ProcessorFactoryException {
    if (_processor == null) {
      _processor = Processor.newInstance("xslt");
    }
    return _processor;
  }

  /**
   * Return a description for this transformation implementation.
   *
   * @return  the implementation's description
   */
  public String getTransformerName() {
    return "Saxon 5.5.1 from ICL";
  }
}
