package wood.keith.opentools.xmltools;

import javax.xml.transform.TransformerFactory;

import com.icl.saxon.TransformerFactoryImpl;

/**
 * Saxon 6.5.3 interface for applying an XSL Transformation to a document.
 * For more details see http://saxon.sourceforge.net.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  28 November 2003
 */
public class XSLSaxon653Transformer extends XSLTraxTransformer {

  // Singleton factory
  private static final TransformerFactory FACTORY =
      TransformerFactoryImpl.newInstance();

  /**
   * Provide the factory that generates transformers.
   *
   * @return  the appropriate factory
   */
  protected TransformerFactory getFactory() { return FACTORY; }

  /**
   * Return a description for this transformation implementation.
   *
   * @return  the implementation's description
   */
  public String getTransformerName() { return "Saxon 6.5.3 from SourceForge"; }
}
