package wood.keith.opentools.xmltools;

import javax.swing.JComponent;
import javax.swing.JOptionPane;

import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.Context;
import com.borland.primetime.node.TextFileNode;
import com.borland.primetime.viewer.AbstractNodeViewer;

/**
 * XSLTNodeViewer is a wrapper around XSLTViewer, which is
 * the class that implements the low level details of managing
 * a viewer, in this case a tabbedpane and several editorpanes.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  16 October 2000
 * @version  2.0  15 February 2002
 */
public class XSLTNodeViewer extends AbstractNodeViewer {

  /**
   * Title and longer description for the viewer tab.
   */
  private static final String TAB_TITLE = "XSLT";
  private static final String TAB_DESC = "XSLT processing";

  /**
   * Messages.
   */
  private static final String TRANSFORMER_MISSING =
    "XSLTransformer class not found";

  /** The implementation of the lower level viewer. */
  private XSLTViewer xsltViewer = null;

  /** The node which holds the XML document to be transformed. */
  private TextFileNode _editorNode;

  /**
   * Create a XSLTNodeViewer object, based on a Context and a Node object,
   * both of which we will get from the XSLTNodeViewerFactory.
   *
   * @param  context     the context of the editor buffer
   * @param  editorNode  the node which holds the XML document
   */
  public XSLTNodeViewer(Context context, TextFileNode editorNode) {
    super(context);
    _editorNode = editorNode;
  }

  /**
   * This title will show on the tab of the viewer.
   */
  public String getViewerTitle() { return TAB_TITLE; }

  /**
   * This is a longer description of the viewer.
   */
  public String getViewerDescription() { return TAB_DESC; }

  /**
   * Creates the UI component for the XSLT pane.
   *
   * @return  the XSLTViewer to display on the XSLT pane
   */
  public JComponent createViewerComponent() {
    if (XSLTViewerFactory.getTransformer() == null) {
      JOptionPane.showMessageDialog(Browser.getActiveBrowser(),
        TRANSFORMER_MISSING, TAB_DESC, JOptionPane.ERROR_MESSAGE);
      return null;
    }
    if (xsltViewer == null) {
      xsltViewer = new XSLTViewer(_editorNode);
    }
    return xsltViewer;
  }

  /**
   * Creates the UI component to display in the Structure Pane.
   * Not yet implemented.
   *
   * @return  null
   */
  public JComponent createStructureComponent() { return null; }

  /**
   * Forces the viewer to a certain line number position.
   *
   * @param  lineNo  the line number the viewer should go to.
   */
  public void setPosition(int lineNo) {
    xsltViewer.setPosition(lineNo);
  }
}
