package wood.keith.opentools.xmltools;

import org.xml.sax.InputSource;

/**
 * Interface for applying an XSL Transformation to a document.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  1.0  16 October 2000
 * @version  2.0  15 February 2002
 */
public interface XSLTransformer {
  /**
   * Apply an XSL transformation to a document.
   *
   * @param  xmlDocument  a source representing the XML document to be transformed
   * @param  xslDocument  a source representing the XSL transformation
   * @return  the text resulting from the transformation process
   * @throws  Exception  when an error occurs, may be a SAXParseException
   *                     showing line and column where the error occurred
   */
  public String transform(InputSource xmlDocument, InputSource xslDocument)
    throws Exception;

  /**
   * Return a description for this transformation implementation.
   *
   * @return  the implementation's description
   */
  public String getTransformerName();
}