package wood.keith.opentools.xmltools;

import javax.xml.transform.TransformerFactory;

import org.apache.xalan.processor.TransformerFactoryImpl;

/**
 * Xalan 2.2 interface for applying an XSL Transformation to a document.
 * For more details see http://xml.apache.org/xalan-j/index.html.
 *
 * @author   Keith Wood (kbwood@iprimus.com.au)
 * @version  2.0  15 February 2002
 */
public class XSLXalan22Transformer extends XSLTraxTransformer {

  // Singleton factory
  private static final TransformerFactory FACTORY =
      TransformerFactoryImpl.newInstance();

  /**
   * Provide the factory that generates transformers.
   *
   * @return  the appropriate factory
   */
  protected TransformerFactory getFactory() { return FACTORY; }

  /**
   * Return a description for this transformation implementation.
   *
   * @return  the implementation's description
   */
  public String getTransformerName() { return "Xalan 2.2 from Apache"; }
}
