/* http://keith-wood.name/icalendar.html
   iCalendar processing for jQuery v1.0.0.
   Written by Keith Wood (kbwood@virginbroadband.com.au) October 2008.
   Dual licensed under the GPL (http://dev.jquery.com/browser/trunk/jquery/GPL-LICENSE.txt) and 
   MIT (http://dev.jquery.com/browser/trunk/jquery/MIT-LICENSE.txt) licenses. 
   Please attribute the author if you use it. */
(function($){var k='icalendar';var l='icalendar-flash-copy';function iCalendar(){this._defaults={sites:[],icons:'icalendar.png',iconSize:16,target:'_blank',compact:false,tipPrefix:'',echoUrl:'',echoField:'',start:null,end:null,title:'',summary:'',description:'',location:'',url:'',contact:'',copyConfirm:'The event will be copied to your clipboard. Continue?',copySucceeded:'The event has been copied to your clipboard',copyFailed:'Failed to copy the event to the clipboard\n',copyFlash:'clipboard.swf',copyUnavailable:'The clipboard is unavailable, please copy the event details from below:\n'};this._sites={'google':{display:'Google',icon:0,url:'http://www.google.com/calendar/event?action=TEMPLATE&text={t}&dates={s}/{e}&details={d}&location={l}'},'icalendar':{display:'iCalendar',icon:1,url:'echo'},'outlook':{display:'Outlook',icon:2,url:'echo'},'yahoo':{display:'Yahoo',icon:3,url:'http://calendar.yahoo.com/?v=60&view=d&type=20&title={t}&st={s}&dur={p}&desc={d}&in_loc={l}'}}}var m=[{method:'Seconds',factor:1},{method:'Minutes',factor:60},{method:'Hours',factor:3600},{method:'Date',factor:86400},{method:'Month',factor:1},{method:'FullYear',factor:12},{method:'Date',factor:604800}];var n=0;var o=1;var p=2;var q=3;var r=4;var s=5;var t=6;$.extend(iCalendar.prototype,{markerClassName:'hasICalendar',setDefaults:function(a){extendRemove(this._defaults,a||{});return this},addSite:function(a,b,c,d){this._sites[a]={display:b,icon:c,url:d};return this},getSites:function(){return this._sites},_attachICalendar:function(a,b){a=$(a);if(a.hasClass(this.markerClassName)){return}a.addClass(this.markerClassName);this._updateICalendar(a,b)},_changeICalendar:function(a,b){a=$(a);if(!a.hasClass(this.markerClassName)){return}this._updateICalendar(a,b)},_updateICalendar:function(e,f){f=extendRemove($.extend({},this._defaults,$.data(e[0],k)||{}),f);$.data(e[0],k,f);if(!e[0].id){e[0].id='ic'+new Date().getTime()}var g=f.sites||this._defaults.sites;if(g.length==0){$.each(this._sites,function(a){g[g.length]=a})}var h=function(a,b){var c=(a.url=='echo'?'#':a.url.replace(/{t}/,escape(f.title)).replace(/{d}/,escape(f.description)).replace(/{s}/,$.icalendar.formatDate(f.start)).replace(/{e}/,$.icalendar.formatDate(f.end)).replace(/{p}/,$.icalendar.calculateDuration(f.start,f.end)).replace(/{l}/,escape(f.location)).replace(/{u}/,escape(f.url)).replace(/{c}/,escape(f.contact)));var d='<li><a href="'+c+'" title="'+f.tipPrefix+a.display+'" '+(a.url=='echo'?'onclick="return jQuery.icalendar._echo(\'#'+e[0].id+'\',\''+b+'\')"':'target="'+f._target+'"')+'>';if(a.icon!=null){if(typeof a.icon=='number'){d+='<span style="background: '+'transparent url('+f.icons+') no-repeat -'+(a.icon*f.iconSize)+'px 0px;'+($.browser.mozilla&&$.browser.version.substr(0,3)!='1.9'?' padding-left: '+f.iconSize+'px; padding-bottom: 3px;':'')+'"></span>'}else{d+='<img src="'+a.icon+'"/>'}d+=(f.compact?'':'&#xa0;')}d+=(f.compact?'':a.display)+'</a></li>';return d};var i='<ul class="icalendar_list'+(f.compact?' icalendar_compact':'')+'">';var j=this._sites;$.each(g,function(a,b){i+=h(j[b],b)});i+='</ul>';e.html(i)},_destroyICalendar:function(a){a=$(a);if(!a.hasClass(this.markerClassName)){return}a.removeClass(this.markerClassName).empty();$.removeData(a[0],k)},_echo:function(a,b){var c=$.data($(a)[0],k);var d=makeICalendar(c);if(c.echoUrl){window.location.href=c.echoUrl+'?content='+escape(d)}else if(c.echoField){$(c.echoField).val(d)}else if(!c.copyFlash){alert(c.copyUnavailable+d)}else if(confirm(c.copyConfirm)){var e='';if(e=copyViaFlash(d,c.copyFlash)){alert(c.copyFailed+e)}else{alert(c.copySucceeded)}}return false},formatDate:function(b,c){var d=function(a){return(a<10?'0':'')+a};b=(b?new Date(b.getTime()):null);return(!b?'':(c?''+b.getFullYear()+d(b.getMonth()+1)+d(b.getDate())+'T'+d(b.getHours())+d(b.getMinutes())+d(b.getSeconds()):''+b.getUTCFullYear()+d(b.getUTCMonth()+1)+d(b.getUTCDate())+'T'+d(b.getUTCHours())+d(b.getUTCMinutes())+d(b.getUTCSeconds())+'Z'))},calculateDuration:function(a,b){if(!a||!b){return''}var c=Math.abs(b.getTime()-a.getTime())/1000;var d=Math.floor(c/86400);c-=d*86400;var e=Math.floor(c/3600);c-=e*3600;var f=Math.floor(c/60);c-=f*60;return(a.getTime()>b.getTime()?'-':'')+'P'+(d>0?d+'D':'')+(e||f||c?'T'+e+'H':'')+(f||c?f+'M':'')+(c?c+'S':'')},addDuration:function(d,e){if(!e){return d}var f=new Date(d.getTime());var g=A.exec(e);if(!g){throw'Invalid duration';}if(g[2]&&(g[3]||g[5]||g[6]||g[7])){throw'Invalid duration - week must be on its own';}if(!g[4]&&(g[5]||g[6]||g[7])){throw'Invalid duration - missing time marker';}var h=(g[1]=='-'?-1:+1);var i=function(a,b,c){a=parseInt(a);if(!isNaN(a)){f['setUTC'+c](f['getUTC'+c]()+h*a*b)}};if(g[2]){i(g[2],7,'Date')}else{i(g[3],1,'Date');i(g[5],1,'Hours');i(g[6],1,'Minutes');i(g[7],1,'Seconds')}return f},parse:function(a){var b={};var c={};var d=unfoldLines(a);parseGroup(d,0,b,c);if(!b.vcalendar){throw'Invalid iCalendar data';}return b.vcalendar},getWeekOfYear:function(a,b){return getWeekOfYear(a,b)}});function extendRemove(a,b){$.extend(a,b);for(var c in b){if(b[c]==null){a[c]=null}}return a}$.fn.icalendar=function(a){var b=Array.prototype.slice.call(arguments,1);return this.each(function(){if(typeof a=='string'){$.icalendar['_'+a+'ICalendar'].apply($.icalendar,[this].concat(b))}else{$.icalendar._attachICalendar(this,a||{})}})};$.icalendar=new iCalendar();function makeICalendar(c){var d=function(a){var b='';while(a.length>75){b+=a.substr(0,75)+'\n';a=' '+a.substr(75)}b+=a;return b};return'BEGIN:VCALENDAR\n'+'VERSION:2.0\n'+'PRODID:jquery.icalendar\n'+'BEGIN:VEVENT\n'+(c.url?d('URL:'+c.url)+'\n':'')+(c.contact?d('MAILTO:'+c.contact)+'\n':'')+d('TITLE:'+c.title)+'\n'+'DTSTART:'+$.icalendar.formatDate(c.start)+'\n'+'DTEND:'+$.icalendar.formatDate(c.end)+'\n'+(c.summary?d('SUMMARY:'+c.summary)+'\n':'')+(c.description?d('DESCRIPTION:'+c.description)+'\n':'')+(c.location?d('LOCATION:'+c.location)+'\n':'')+'END:VEVENT\n'+'END:VCALENDAR'}function copyViaFlash(a,b){$('#'+l).remove();try{$('body').append('<div id="'+l+'"><embed src="'+b+'" FlashVars="clipboard='+encodeURIComponent(a)+'" width="0" height="0" type="application/x-shockwave-flash"></embed></div>');return''}catch(e){return e}}var u=/^\s(.*)$/;var v=/^([^:]+):(.*)$/;var w=/^(\d{4})(\d\d)(\d\d)$/;var x=/^(\d{4})(\d\d)(\d\d)T(\d\d)(\d\d)(\d\d)(Z?)$/;var y=/^(\d{4})(\d\d)(\d\d)T(\d\d)(\d\d)(\d\d)(Z?)\/(\d{4})(\d\d)(\d\d)T(\d\d)(\d\d)(\d\d)(Z?)$/;var z=/^([+-])(\d\d)(\d\d)$/;var A=/^([+-])?P(\d+W)?(\d+D)?(T)?(\d+H)?(\d+M)?(\d+S)?$/;var B=['class'];function unfoldLines(b){var c=b.split('\n');for(var i=c.length-1;i>0;i--){var d=u.exec(c[i]);if(d){c[i-1]+=d[1];c[i]=''}}return $.map(c,function(a,i){return(a?a:null)})}function parseGroup(a,b,c,d){if(b>=a.length||a[b].indexOf('BEGIN:')!=0){throw'Missing group start';}var e={};var f=a[b].substr(6);addEntry(c,f.toLowerCase(),e);b++;while(b<a.length&&a[b].indexOf('END:')!=0){if(a[b].indexOf('BEGIN:')==0){b=parseGroup(a,b,e,d)}else{var g=parseEntry(a[b]);addEntry(e,g._name,(g._simple?g._value:g))}b++}if(f=='VTIMEZONE'){var h=z.exec(e.standard.tzoffsetto);if(h){d[e.tzid]=(h[1]=='-'?-1:+1)*(parseInt(h[2])*60+parseInt(h[3]))}}else{for(var i in e){resolveTimezones(e[i],d)}}if(a[b]!='END:'+f){throw'Missing group end '+f;}return b}function resolveTimezones(c,d){if(!c){return}if(c.tzid&&c._value){var e=d[c.tzid];var f=function(a,b){a.setMinutes(a.getMinutes()-e);a._type=b};if(isArray(c._value)){for(var i=0;i<c._value.length;i++){f(c._value[i],c.tzid)}}else if(c._value.start&&c._value.end){f(c._value.start,c.tzid);f(c._value.end,c.tzid)}else{f(c._value,c.tzid)}}else if(isArray(c)){for(var i=0;i<c.length;i++){resolveTimezones(c[i],d)}}}function addEntry(a,b,c){if(typeof c=='string'){c=c.replace(/\\n/g,'\n')}if($.inArray(b,B)>-1){b+='_'}if(a[b]){if(!isArray(a[b])||a['_'+b+'IsArray']){a[b]=[a[b]]}a[b][a[b].length]=c;if(a['_'+b+'IsArray']){a['_'+b+'IsArray']=undefined}}else{a[b]=c;if(isArray(c)){a['_'+b+'IsArray']=true}}}function parseEntry(a){var b={};var c=v.exec(a);if(!c){throw'Missing entry name: '+a;}var d=c[1].split(';');b._name=d[0].toLowerCase();b._value=checkDate(c[2]);b._simple=true;parseParams(b,d.slice(1));return b}function parseParams(a,b){b=(isArray(b)?b:b.split(';'));a._simple=true;for(var i=0;i<b.length;i++){var c=b[i].split('=');a[c[0].toLowerCase()]=checkDate(c[1]||'');a._simple=false}}function checkDate(a){var b=x.exec(a);if(b){return makeDate(b)}b=y.exec(a);if(b){return{start:makeDate(b),end:makeDate(b.slice(7))}}b=w.exec(a);if(b){return makeDate(b.concat([0,0,0,'']))}return a}function makeDate(a){var b=new Date(a[1],a[2]-1,a[3],a[4],a[5],a[6]);b._type=(a[7]?'UTC':'float');return utcDate(b)}function utcDate(a){a.setMinutes(a.getMinutes()-a.getTimezoneOffset());return a}function getWeekOfYear(a,b){b=(b||b==0?b:1);var c=new Date(a.getFullYear(),a.getMonth(),a.getDate(),(a.getTimezoneOffset()/-60));var d=new Date(c.getFullYear(),1-1,4);var e=d.getDay();d.setDate(4+b-e-(b>e?7:0));if(c<d){c.setDate(c.getDate()-3);return getWeekOfYear(c,b)}else if(c>new Date(c.getFullYear(),12-1,28)){var f=new Date(c.getFullYear()+1,1-1,4);e=f.getDay();f.setDate(4+b-e-(b>e?7:0));if(c>=f){return 1}}return Math.floor(((c-d)/(m[q].factor*1000))/7)+1}function isArray(a){return(a&&a.constructor==Array)}})(jQuery);